package org.netbeans.modules.tasklist.usertasks;

import java.util.Comparator;
import java.util.Iterator;

import org.netbeans.modules.tasklist.usertasks.treetable.AdvancedTreeTableNode;
import org.netbeans.modules.tasklist.usertasks.treetable.FilterIntf;
import org.openide.util.NbBundle;
import org.netbeans.modules.tasklist.core.util.ObjectList;
import org.netbeans.modules.tasklist.usertasks.model.UserTask;
import org.netbeans.modules.tasklist.usertasks.model.UserTaskList;

/**
 * Task node
 *
 * @author tl
 */
public class UserTaskListTreeTableNode extends AdvancedTreeTableNode {
    public static final int SUMMARY = 0;
    public static final int PRIORITY = 1;
    public static final int DONE = 2;
    public static final int PERCENT_COMPLETE = 3;
    public static final int EFFORT = 4;
    public static final int REMAINING_EFFORT = 5;
    public static final int SPENT_TIME = 6;
    public static final int DETAILS = 7;
    public static final int FILE_BASE_NAME = 8;
    public static final int LINE_NUMBER = 9;
    public static final int CATEGORY = 10;
    public static final int CREATED = 11;
    public static final int LAST_EDITED = 12;
    public static final int DUE_DATE = 13;
    
    private ObjectList.Listener tl;
    
    /** 
     * Creates a new instance of UserTaskTreeTableNode
     *  
     * @param filter filter to be used or null
     * @param ut a user task list
     * @param m model for this node
     * @param comparator comparator to be used or null
     */
    public UserTaskListTreeTableNode(FilterIntf filter, 
    UserTasksTreeTableModel m, UserTaskList ut, Comparator comparator) {
        super(m, null, ut);
        this.filter = filter;
        this.comparator = comparator;
        tl = new ObjectList.Listener() {
            public void listChanged(ObjectList.Event ev) {
                switch (ev.getType()) {
                    case ObjectList.Event.EVENT_ADDED: {
                    	Object[] obj = ev.getObjects();
                    	for (int i = 0; i < obj.length; i++) {
                            fireChildObjectAdded(obj[i]);
                    	}
                        break;
                    }
                    case ObjectList.Event.EVENT_REMOVED: {
                    	Object[] obj = ev.getObjects();
                    	for (int i = 0; i < obj.length; i++) {
                            fireChildObjectRemoved(obj[i]);
                    	}
                        break;
                    }
                    case ObjectList.Event.EVENT_REORDERED: 
                    	fireChildObjectsReordered();
                        break;
                    case ObjectList.Event.EVENT_STRUCTURE_CHANGED:
                    	refreshChildren();
                        break;
                }
            }
        };
        ut.getSubtasks().addListener(tl);
    }
    
    public Object getValueAt(int column) {
        switch (column) {
            case SUMMARY:
                return NbBundle.getMessage(UserTaskListTreeTableNode.class, "TaskList");  // NOI18N
            default:
                return null;
        }
    }    
    
    public void setValueAt(Object aValue, int column) {
    }

    /**
     * Returns user task list associated with this node
     *
     * @return user task list
     */
    public UserTaskList getUserTaskList() {
        return (UserTaskList) object;
    }
    
    public void destroy() {
        super.destroy();
        this.getUserTaskList().getSubtasks().removeListener(tl);
    }    
    
    public Iterator getChildrenObjectsIterator() {
        return getUserTaskList().getSubtasks().iterator();
    }
    
    public AdvancedTreeTableNode createChildNode(Object child) {
        UserTaskTreeTableNode n = new UserTaskTreeTableNode(
            this, filter, (UserTasksTreeTableModel) model, 
            (UserTask) child, comparator);
        if (getFilter() != null && !getFilter().accept(child))
            n.setUnmatched(true);
        return n;
    }
    
    public boolean accept(Object child) {
        if (getFilter() == null)
            return true;
        
        return UserTaskTreeTableNode.acceptsRecursively(
            (UserTask) child, getFilter());
    }
    
    public boolean isCellEditable(int column) {
        return false;
    }    
}
