package org.netbeans.modules.tasklist.usertasks;

import java.util.List;
import javax.swing.Action;
import javax.swing.tree.TreePath;

import org.netbeans.modules.tasklist.core.export.ExportAction;
import org.netbeans.modules.tasklist.core.export.ImportAction;
import org.netbeans.modules.tasklist.core.filter.FilterAction;
import org.netbeans.modules.tasklist.core.filter.RemoveFilterAction;
import org.netbeans.modules.tasklist.usertasks.actions.ClearCompletedAction;
import org.netbeans.modules.tasklist.usertasks.actions.CollapseAllAction;
import org.netbeans.modules.tasklist.usertasks.actions.CopyHoursToClipboardAction;
import org.netbeans.modules.tasklist.usertasks.actions.ExpandAllUserTasksAction;
import org.netbeans.modules.tasklist.usertasks.actions.NewTaskAction;
import org.netbeans.modules.tasklist.usertasks.actions.PurgeTasksAction;
import org.netbeans.modules.tasklist.usertasks.model.UserTask;
import org.openide.actions.PasteAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.netbeans.modules.tasklist.usertasks.model.UserTaskList;
import org.netbeans.modules.tasklist.usertasks.treetable.AdvancedTreeTableNode;
import org.openide.util.datatransfer.PasteType;

/**
 * Node for a user task list
 *
 * @author tl
 */
public class UserTaskListNode extends AbstractNode {
    private UserTaskList tasklist;
    private UserTasksTreeTable utt;
    
    /**
     * Creates plain tasklist node. Properties that cannot
     * be derrived from passed tasklist should be provided by
     * client. It covers displayName etc.
     *
     * @param tasklist to be visualized never <code>null</code>
     * @param utt TT with user tasks
     * @param node TT node representing this node
     */
    public UserTaskListNode(UserTaskList tasklist, UserTasksTreeTable utt) {
        super(Children.LEAF);

        this.tasklist = tasklist;
        this.utt = utt;
        updateIcon();
        setDisplayName(NbBundle.getMessage(UserTaskListNode.class, 
            "RootTaskSummary")); // NOI18N
    }

    /**
     * Returns the tasklist associated with this node
     *
     * @return user task list
     */
    public UserTaskList getUserTaskList() {
        return tasklist;
    }
    
    public Action[] getActions(boolean empty) {
        return new Action[] {
            SystemAction.get(NewTaskAction.class),
            //SystemAction.get(ShowScheduleViewAction.class),
            null,
            SystemAction.get(PasteAction.class),
            null,
            SystemAction.get(FilterAction.class),
            SystemAction.get(RemoveFilterAction.class),
            null,
            SystemAction.get(PurgeTasksAction.class),
            SystemAction.get(ClearCompletedAction.class),
            new CopyHoursToClipboardAction(),
            null,
            SystemAction.get(ExpandAllUserTasksAction.class),
            SystemAction.get(CollapseAllAction.class),
            null,
            SystemAction.get(ImportAction.class),
            SystemAction.get(ExportAction.class),
        };
    }

    protected void updateIcon() {
        setIconBaseWithExtension(
                "org/netbeans/modules/tasklist/usertasks/tasklistfile.gif"); // NOI18N
    }

    protected void createPasteTypes(java.awt.datatransfer.Transferable t, List s) {
        // UTUtils.LOGGER.fine("entering"); // NOI18N
        super.createPasteTypes(t, s);
        PasteType p = UserTaskNode.createTodoPasteType(this, t);
        if (p != null) {
            s.add(p);
        }
    }

    /**
     * Performs "Paste" for the specified task on this node
     *
     * @param t task to be pasted
     */
    public void pasteTask(UserTask t) {
        t = (UserTask) t.clone();
        tasklist.getSubtasks().add(t);
        UserTasksTreeTableModel m = (UserTasksTreeTableModel) utt.getTreeTableModel();
        UserTaskListTreeTableNode rn = (UserTaskListTreeTableNode) m.getRoot();
        int index = rn.getIndexOfObject(t);
        if (index >= 0) {
            AdvancedTreeTableNode n = 
                (AdvancedTreeTableNode) rn.getChildAt(index);
            TreePath tp = new TreePath(n.getPathToRoot());
            utt.expandAllPath(tp);
            utt.select(tp);
            utt.scrollTo(tp);
        }
    }
}
