package org.netbeans.modules.tasklist.usertasks;

import java.util.Comparator;
import java.util.Iterator;

import org.netbeans.modules.tasklist.usertasks.treetable.AdvancedTreeTableNode;
import org.netbeans.modules.tasklist.usertasks.treetable.FilterIntf;
import org.openide.util.NbBundle;
import org.netbeans.modules.tasklist.core.util.ObjectList;
import org.netbeans.modules.tasklist.usertasks.model.UserTask;
import org.netbeans.modules.tasklist.usertasks.model.UserTaskList;

/**
 * Task node
 */
public class UTListDependenciesTreeTableNode extends UserTaskListTreeTableNode {
    private ObjectList.Listener tl;
    
    /** 
     * Creates a new instance of UserTaskTreeTableNode
     *  
     * @param filter filter to be used or null
     * @param ut a user task list
     * @param m model for this node
     * @param comparator comparator to be used or null
     */
    public UTListDependenciesTreeTableNode(FilterIntf filter, 
    UserTasksTreeTableModel m, UserTaskList ut, Comparator comparator) {
        super(filter, m, ut, comparator);
    }
    
    public AdvancedTreeTableNode createChildNode(Object child) {
        UTDependenciesTreeTableNode n = new UTDependenciesTreeTableNode(
            this, filter, (UserTasksTreeTableModel) model, 
            (UserTask) child, comparator);
        if (getFilter() != null && !getFilter().accept(child))
            n.setUnmatched(true);
        return n;
    }
    
    public boolean accept(Object child) {
        if (getFilter() == null)
            return true;
        
        return UTDependenciesTreeTableNode.acceptsRecursivelyDep(
            (UserTask) child, getFilter());
    }

    public Iterator getChildrenObjectsIterator() {
        return getUserTaskList().getAllSubtasks().iterator();
    }
}
