package org.netbeans.modules.tasklist.usertasks;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.tasklist.usertasks.model.Dependency;

import org.netbeans.modules.tasklist.usertasks.treetable.AdvancedTreeTableNode;
import org.netbeans.modules.tasklist.usertasks.treetable.FilterIntf;
import org.netbeans.modules.tasklist.usertasks.treetable.TreeTableNode;
import org.netbeans.modules.tasklist.usertasks.model.UserTask;

/**
 * Task node
 */
public class UTDependenciesTreeTableNode extends UserTaskTreeTableNode {
    /**
     * Filters a task.
     *
     * @return true if the filter accepts <code>ut</code> or one of 
     * it's subtasks
     */
    public static boolean acceptsRecursivelyDep(UserTask ut, FilterIntf filter) {
        if (filter.accept(ut))
            return true;
        Iterator it = ut.getDependencies().iterator();
        while (it.hasNext()) {
            Dependency child = (Dependency) it.next();
            if (acceptsRecursivelyDep(child.getDependsOn(), filter))
                return true;
        }
        return false;
    }
    
    /** 
     * Creates a new instance of UserTaskTreeTableNode
     *  
     * @param filter filter to be used or null
     * @param ut a user task
     * @param m model for this node
     * @param comparator comparator to be used or null
     */
    public UTDependenciesTreeTableNode(
    TreeTableNode parent, FilterIntf filter, 
    UserTasksTreeTableModel m, UserTask ut, Comparator comparator) {
        super(parent, filter, m, ut, comparator);
        
        /*this.filter = filter;
        this.comparator = comparator;
        pcl = new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                fireObjectChanged();
            }
        };
        ut.addPropertyChangeListener(pcl);*/
        /* TODO: add listener tl = new ObjectList.Listener() {
            public void listChanged(ObjectList.Event e) {
                switch (e.getType()) {
                    case ObjectList.Event.EVENT_ADDED: {
                        Object[] obj = e.getObjects();
                        for (int i = 0; i < obj.length; i++) {
                            fireChildObjectAdded(obj[i]);
                        }
                        break;
                    }
                    case ObjectList.Event.EVENT_REMOVED: {
                        Object[] obj = e.getObjects();
                        for (int i = 0; i < obj.length; i++) {
                            fireChildObjectRemoved(obj[i]);
                        }
                        break;
                    }
                    case ObjectList.Event.EVENT_REORDERED:
                        fireChildObjectsReordered();
                        break;
                    case ObjectList.Event.EVENT_STRUCTURE_CHANGED:
                        refreshChildren();
                        break;
                    default:
                        throw new InternalError("unexpected event type"); // NOI18N
                }
            }
        };
        ut.getSubtasks().addListener(tl);*/
    }
    
    public boolean isLeaf() {
        return getUserTask().getDependencies().isEmpty();
    }
    
    /* TODO: remove registered listeners public void destroy() {
        super.destroy();
        getUserTask().getSubtasks().removeListener(tl);
        getUserTask().removePropertyChangeListener(pcl);
    }    */
    
    public Iterator getChildrenObjectsIterator() {
        List tasks = new ArrayList(getUserTask().getDependencies().size());
        for (int i = 0; i < getUserTask().getDependencies().size(); i++) {
            Dependency d = (Dependency) getUserTask().getDependencies().get(i);
            tasks.add(d.getDependsOn());
        }
        return tasks.iterator();
    }
    
    public AdvancedTreeTableNode createChildNode(Object child) {
        UTDependenciesTreeTableNode n = new UTDependenciesTreeTableNode(
            this, filter, (UserTasksTreeTableModel) model, 
            (UserTask) child, comparator);
        if (getFilter() != null && !getFilter().accept(child))
            n.unmatched = true;
        return n;
    }    
    
    public boolean accept(Object child) {
        if (getFilter() == null)
            return true;
        
        return acceptsRecursivelyDep((UserTask) child, getFilter());
    }
}
