/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.tasklist.pmd;

import java.awt.*;
import javax.swing.*;
import org.openide.util.NbBundle;

import javax.swing.text.*;


/**
 * A confirmation panel for suggestion fixes etc.
 *
 * @author  Tor Norbye
 */
public class ConfPanel extends javax.swing.JPanel {

    private static final long serialVersionUID = 1;

    /** Creates new form ConfPanel */
    public ConfPanel(String beforeDesc, String beforeContents,
                     String afterDesc, String afterContents,
                     String filename, int line) {
        initComponents();
        
        mainLabel.setText(beforeDesc);
        beforeLabel.setText(beforeContents);
        if (afterDesc != null) {
            changedToLabel.setText(afterDesc);
        } else {
            changedToLabel.setVisible(false);
        }
        if (afterContents != null) {
            afterLabel.setText(afterContents);
        } else {
            afterLabel.setVisible(false);
            jScrollPane2.setVisible(false);
        }
        fileLabel.setText(filename);
        if (line >= 0) {
            lineLabel.setText(Integer.toString(line));
        } else {
            lineLabel.setVisible(false);
            jLabel5.setVisible(false);
        }
        Dimension d = jScrollPane1.getPreferredSize();
        int width = (int)d.getWidth();
        int height = (int)d.getHeight();
        if ((width > 400) || (height > 200)) {
            if (width > 400) {
                width = 400;
            }
            if (height > 200) {
                height = 200;
            }
            jScrollPane1.setPreferredSize(new Dimension(width, height));
        }
        d = jScrollPane2.getPreferredSize();
        width = (int)d.getWidth();
        height = (int)d.getHeight();
        if ((width > 400) || (height > 200)) {
            if (width > 400) {
                width = 400;
            }
            if (height > 200) {
                height = 200;
            }
            jScrollPane2.setPreferredSize(new Dimension(width, height));
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mainLabel = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        beforeLabel = new javax.swing.JLabel();
        changedToLabel = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        afterLabel = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        fileLabel = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        lineLabel = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        setPreferredSize(new java.awt.Dimension(600, 400));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 11);
        add(mainLabel, gridBagConstraints);

        beforeLabel.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        beforeLabel.setBackground((java.awt.Color) javax.swing.UIManager.getDefaults().get("TextField.background"));
        beforeLabel.setOpaque(true);
        jScrollPane1.setViewportView(beforeLabel);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 11);
        add(jScrollPane1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 11);
        add(changedToLabel, gridBagConstraints);

        afterLabel.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        afterLabel.setBackground((java.awt.Color) javax.swing.UIManager.getDefaults().get("TextField.background"));
        afterLabel.setOpaque(true);
        jScrollPane2.setViewportView(afterLabel);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 11);
        add(jScrollPane2, gridBagConstraints);

        jLabel3.setText(NbBundle.getMessage(ConfPanel.class, "File")); // NOI18N();
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(18, 12, 0, 11);
        add(jLabel3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(18, 0, 0, 11);
        add(fileLabel, gridBagConstraints);

        jLabel5.setText(NbBundle.getMessage(ConfPanel.class, "Line")); // NOI18N();
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 11);
        add(jLabel5, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 11);
        add(lineLabel, gridBagConstraints);

    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel mainLabel;
    private javax.swing.JLabel fileLabel;
    private javax.swing.JLabel changedToLabel;
    private javax.swing.JLabel beforeLabel;
    private javax.swing.JLabel afterLabel;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel lineLabel;
    // End of variables declaration//GEN-END:variables
    
}
