/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.tasklist.javaparser;

import javax.swing.text.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.openide.ErrorManager;
import org.openide.cookies.SourceCookie;
import org.openide.explorer.view.*;
import org.openide.nodes.*;
import org.netbeans.modules.java.*;



import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

import org.openide.cookies.LineCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.ErrorManager;

import java.util.TreeSet;
import java.lang.reflect.Modifier;
import org.netbeans.editor.ext.java.*;
import org.netbeans.modules.editor.java.*;

import org.netbeans.modules.tasklist.core.ConfPanel;
import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.client.Suggestion;
import org.netbeans.modules.tasklist.client.SuggestionPerformer;


/**
 * This class performs symbol replacement suggestions
 *
 * @author Tor Norbye
 */
class ReplaceSymbolPerformer implements SuggestionPerformer {
    
    private int lineno;
    private int col;
    private Line line;
    private DataObject dobj;
    private Document doc;
    private String oldSymbol;
    private String newSymbol;
    private String beforeDesc;
    private String afterDesc;
    private JCClass importClass;
    private boolean makeMethod;

    ReplaceSymbolPerformer(int lineno, int col, Line line, DataObject dobj,
                           Document doc,
                           String oldSymbol, String newSymbol,
                           String beforeDesc, String afterDesc,
                           JCClass importClass, boolean makeMethod) {
        this.lineno = lineno;
        this.col = col;
        this.line = line;
        this.dobj = dobj;
        this.doc = doc;
        this.oldSymbol = oldSymbol;
        this.newSymbol = newSymbol;
        this.beforeDesc = beforeDesc;
        this.afterDesc = afterDesc;
        this.importClass = importClass;
        this.makeMethod = false;

    }

    // Yay - it's a casing-error
    public void perform(Suggestion s) {
        if (makeMethod) {
            makeMethod();
        } else {
            replaceSymbol();
            if (importClass != null) {
                ImportPerformer.importClass(doc, importClass);
            }
        }
    }

     public boolean hasConfirmation() {
         return true;
     }
     
     public Object getConfirmation(Suggestion s) {
         String filename =
             dobj.getPrimaryFile().getNameExt();
         StringBuffer sb = new StringBuffer(200);
         Line l = line;
         String text = l.getText();
         
         // Underline differences
         int fd = TLUtils.firstDiff(oldSymbol, newSymbol);
         int ldo = oldSymbol.length()- TLUtils.lastDiff(oldSymbol, newSymbol);
         int ldn = newSymbol.length() - TLUtils.lastDiff(oldSymbol, newSymbol);
         sb.append("<html>"); // NOI18N
         TLUtils.appendSurroundingLine(sb, l, -1);
         JPUtils.replaceSymbol(sb, text, col, oldSymbol, oldSymbol,
                               true, fd, ldo);
         TLUtils.appendSurroundingLine(sb, l, +1);
         sb.append("</html>"); // NOI18N
         String beforeContents = sb.toString();
         
         sb.setLength(0);
         sb.append("<html>");
         if (importClass != null) {
             sb.append("<b>import "); // NOI18N
             sb.append(importClass.toString());
             sb.append(";</b><br>...<br>"); // NOI18N
         }
         TLUtils.appendSurroundingLine(sb, l, -1);
         JPUtils.replaceSymbol(sb, text, col, oldSymbol, newSymbol,
                               true, fd, ldn);
         TLUtils.appendSurroundingLine(sb, l, +1);
         sb.append("</html>"); // NOI18N
         String afterContents = sb.toString();
         return new ConfPanel(beforeDesc, beforeContents, afterDesc, 
                              afterContents, filename, lineno, null);
     }

    /** Replace one symbol reference with another */
     boolean replaceSymbol() {
        //System.out.println("ReplaceSymbol '" + symbol + "' with '" + newSymbol + "')");
        //System.out.println("line=" + lineno);
        if (!(doc instanceof StyledDocument)) {
            return false;
        }
        
        // HACK
        lineno--;
        
        StyledDocument sdoc = (StyledDocument)doc;
        Element e = sdoc.getParagraphElement(0).getParentElement();
        if (e == null) {
            // try default root (should work for text/plain)
            e = sdoc.getDefaultRootElement();
        }
        Element elm = e.getElement(lineno);
        if (elm == null) {
            return false;
        }
        int offset = elm.getStartOffset();
        int endOffset = elm.getEndOffset();

        try {
            String text = sdoc.getText(offset, endOffset-offset);
            // "dumb" implementation - do multiple replacements

            // iterate backwards, look for hits; when one is found,
            // ensure that it's bracketed by non javaidentifierparts
            // and if so, substitute
            // (we go backwards such that our substitutions don't
            // affect the document indices!)
            int symLen = oldSymbol.length();
            int texLen = text.length();
            int n = texLen-symLen;
            while (true) {
                if (n < 0) {
                    break;
                }

                if (text.startsWith(oldSymbol, n)) {
                    // Found match
                    if ((n > 0) &&
                        Character.isJavaIdentifierPart(text.charAt(n-1))) {
                        n--;
                        continue;
                    }
                    if ((n+symLen+1 < texLen-1) &&
                        Character.isJavaIdentifierPart(text.charAt(n+symLen))) {
                        n--; // XXX could I jump back by symLen here? 
                        // What if the symbol is "aaa" ? Not a problem
                        continue;
                    }

                    int pos = offset + n;
                    sdoc.remove(pos, symLen);
                    sdoc.insertString(pos, newSymbol, null);
                   // See XXX jump comment earlier - can I jump symLen-1 here?
                }
                n--;
            }
        } catch (BadLocationException ex) {
            ErrorManager.getDefault().notify(ErrorManager.WARNING, ex);
        }
        return false;
    }


    /** Make a method out of the given symbol 
     * <p>
     * @todo NOTE that this is very similar to replaceSymbol (because
     * we cannnot trust the column number handed to us by the compiler.
     * The difference seems to be that here we want to make a single
     * substitution, whereas the other replacements replace all. 
     * Make THAT the flag differentiator (replaceAll, replaceSingle)
     * rather than focus on this usage as a method with the makeMethod
     * flag!
     */
    boolean makeMethod() {
        //System.out.println("MakeMethod out of '" + oldSymbol + "' where the identified method was " + mtd + " (" + mtd.getClass().getName() + ")");
        //System.out.println("line=" + lineno + " and col = " + col);
        // TODO
        if (!(doc instanceof StyledDocument)) {
            return false;
        }
        
        // HACK
        lineno--;
        
        StyledDocument sdoc = (StyledDocument)doc;
        
        Element e = sdoc.getParagraphElement(0).getParentElement();
        if (e == null) {
            // try default root (should work for text/plain)
            e = sdoc.getDefaultRootElement();
        }
        Element elm = e.getElement(lineno);
        if (elm == null) {
            return false;
        }
        int offset = elm.getStartOffset();
        int endOffset = elm.getEndOffset();
        
        try {
            String text = sdoc.getText(offset, endOffset-offset);
            col--; // The position should be zero based!

            if (text.substring(col).startsWith(oldSymbol)) {
                int pos = offset + col + oldSymbol.length();
                sdoc.insertString(pos, "()", null);
            } else if (text.substring(col+1).startsWith(oldSymbol)) {
                // For some reason, on some systems (like OSX) I've seen
                // a 0-based position too!
                int pos = offset + col+1 + oldSymbol.length();
                sdoc.insertString(pos, "()", null);
            } else {
                // Interestingly, at least on OSX with jdk1.3, I may get
                // a "wrong" column, e.g. it will point at "foo" in
                // "foo".length
                // ^
                // So I've gotta start searching forward
                int x = text.indexOf(oldSymbol, col+2); // +2: already checked 0,1
                int nx = x+oldSymbol.length();
                if ((x+oldSymbol.length() < text.length()-1) ||
                    !Character.isJavaIdentifierPart(text.charAt(nx))) {
                    int pos = offset + nx;
                    sdoc.insertString(pos, "()", null);
                }
            }
        } catch (BadLocationException ex) {
            ErrorManager.getDefault().notify(ErrorManager.WARNING, ex);
        }
        return false;
    }
    
    

}

