/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.tasklist.javaparser;

import javax.swing.text.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.openide.ErrorManager;
import org.openide.cookies.SourceCookie;
import org.openide.explorer.view.*;
import org.openide.nodes.*;
import org.netbeans.modules.java.*;
import org.openide.src.*;
import org.openide.text.NbDocument;


import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

import org.openide.cookies.LineCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.ErrorManager;

import java.util.TreeSet;
import java.lang.reflect.Modifier;
import org.netbeans.editor.ext.java.*;
import org.netbeans.modules.editor.java.*;

import org.netbeans.modules.tasklist.core.ConfPanel;
import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.client.Suggestion;
import org.netbeans.modules.tasklist.client.SuggestionPerformer;


/**
 * This class performs symbol replacement suggestions
 *
 * @author Tor Norbye
 */
class CreateMethodPerformer implements SuggestionPerformer {
    
    private DataObject dobj;
    private Document doc;
    private String symbol;
    private String location;
    private String args;
    private boolean makePublic;

    CreateMethodPerformer(DataObject dobj,
                          String symbol, String location,
                          String args, boolean makePublic) {
        this.dobj = dobj;
        this.symbol = symbol;
        this.location = location;
        this.args = args;
        this.makePublic = makePublic;
    }

    // Yay - it's a casing-error
    public void perform(Suggestion s) {
        SourceCookie sc = null;
        sc = (SourceCookie)dobj.getCookie(SourceCookie.Editor.class);
        if (sc == null) {
            return;
        }
        SourceElement se = sc.getSource();
        if (se == null) {
            return;
        }
        ClassElement[] classes = se.getClasses();
        if (classes == null) {
            return;
        }
        String none = 
            NbBundle.getMessage(CreateMethodPerformer.class, "NoArgs");//NOI18N
        for (int i = 0; i < classes.length; i++) {
            if (classes[i].isInner()) {
                // Inner class - probably not the one we're looking for
            } else {
                MethodElement el = null;
                try {
                    el = new MethodElement();
                    el.setName(Identifier.create(symbol));
                    if (makePublic) {
                        int mask = Modifier.PUBLIC;
                        el.setModifiers(mask);
                    }
                    // TODO Figure out which modifier I need. If it's in
                    // my own package, it should be package private
                    // (the default) otherwise, set it to public
                    //el.setModifiers();

                    // Do I get a return type out of the compiler error?
                    // Can I tell from the context?

                    //el.setReturn(Type ret);
                    // XXX el.addJavaDoc(" /**@todo Implement the body of " + symbol + "(" + args + ") */");
                    MethodParameter[] params;
                    ArrayList plist = new ArrayList();
                    int begin = 0;
                    while (true) {
                        int next = args.indexOf(',', begin);
                        String arg = null;
                        if (next == -1) {
                            arg = args.substring(begin);
                        } else {
                            arg = args.substring(begin, next);
                        }
                        if ((arg.length() > 0) && !args.equals(none)) {
                            plist.add(arg);
                        }
                        if (next != -1) {
                            begin = next+1;
                        } else {
                            break;
                        }
                    }
                    params = new MethodParameter[plist.size()];
                    Type[] types = new Type[plist.size()];
                    for (int j = 0; j < params.length; j++) {
                        Type type = Type.parse(plist.get(j).toString());
                        types[j] = type;
                        boolean fin = false; // final?
                        // How do we name the parameters? 
                        String name = "param"+(j+1);
                        params[j] = new MethodParameter(name, type, fin);
                    }
                    el.setParameters(params);

                    el.setBody("\n/**@todo Implement this method*/\nthrow new java.lang.UnsupportedOperationException(\n          \"Method " + symbol + "("+args+") not yet implemented.\");\n");
                    classes[i].addMethod(el);

                    MethodElement nel = classes[i].getMethod(Identifier.create(symbol), types);
                    if (nel != null) {
                        // Show the source code
                        SourceCookie.Editor editor = 
                           (SourceCookie.Editor)dobj.getCookie(SourceCookie.Editor.class);
                        javax.swing.text.Element textElement = editor.sourceToText(nel);
                        if (textElement != null) {
                            StyledDocument document = editor.getDocument();
                            if (document != null) {
                                int offset = textElement.getStartOffset();
                                int lineNumber = NbDocument.findLineNumber(document, offset);
                                Line line = editor.getLineSet().getCurrent(lineNumber);
                                line.show(line.SHOW_GOTO);
                            }
                        }
                    }

                    
                } catch (SourceException e) {
                    e.printStackTrace();
                }
                break; // Only for the first top level class
                /// XXX That is not right!
            }
        }
    }

     public boolean hasConfirmation() {
         return true;
     }

    /**
     * @todo Instead of hardcoding the method text here, do the same
     *  as in perform() where we create a MethodElement, and then just
     *  do getRawText() or getBody() on the memory methodelement (don't
     *  actually add it to the ClassElement obviously.)
     */
     public Object getConfirmation(Suggestion s) {
         String none = 
            NbBundle.getMessage(CreateMethodPerformer.class, "NoArgs");//NOI18N
         if (args.equals(none)) {
             args = "";
         }
         String beforeDesc =
             NbBundle.getMessage(ErrorSuggester.class,
                                 "CreateMethodDesc", location); // NOI18N
         String afterDesc =
             NbBundle.getMessage(ErrorSuggester.class,
                                 "CreateMethodAfter"); // NOI18N
         String beforeContents = "<html><body><b>" + (makePublic? "public " : "") + "void " + symbol + "</b>(" + args + ") {<br><i>&nbsp;&nbsp;&nbsp;&nbsp;/**@todo Implement this method*/</i><br><b>&nbsp;&nbsp;&nbsp;&nbsp;throw new </b>java.lang.<b>UnsupportedOperationException</b>(<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\"Method " + symbol + "("+args+") not yet implemented.\");<br>}</body></html>";
         String filename =
             dobj.getPrimaryFile().getNameExt();
         return new ConfPanel(beforeDesc, beforeContents, afterDesc,
                              null, filename, -1, null);
     }

    

}

