package org.netbeans.modules.tasklist.javadoc;

import java.lang.reflect.Modifier;
import org.openide.src.ClassElement;
import org.openide.src.MemberElement;

/**
 *
 */
public class JavaDocUtils {
    /** 
     * Creates a new instance of JavaDocUtils 
     */
    private JavaDocUtils() {
    }

    public static int getEffectiveAccess(MemberElement el) {
        int access = el.getModifiers() & (Modifier.PUBLIC | Modifier.PROTECTED | Modifier.PRIVATE);
        if (access == Modifier.PRIVATE)
            return access;
        ClassElement decl = el.getDeclaringClass();
        if (decl == null)
            // it is a top-level class
            return access;
        if (!decl.isClassOrInterface())
            // interface members must be public
            access = Modifier.PUBLIC;
        
        int parentAccess = getEffectiveAccess(decl);
        switch (parentAccess) {
            case Modifier.PRIVATE:
            case 0:
                // private members were handled above, everything else is 
                // constrained by parent's privacy
                return parentAccess;
            case Modifier.PROTECTED:
                // member can be restricted to only the package
                return access == 0 ? 0 : parentAccess;
            case Modifier.PUBLIC:
            default:
                return access;
        }
    }
}
