/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.tasklist.javadoc;

import javax.swing.text.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.lang.reflect.Modifier;
import javax.swing.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.openide.ErrorManager;
import org.openide.cookies.SourceCookie;
import org.openide.explorer.view.*;
import org.openide.nodes.*;


import org.openide.src.*;
import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

import org.openide.cookies.LineCookie;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.ErrorManager;
import org.openide.text.NbDocument;

import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.client.Suggestion;
import org.netbeans.modules.tasklist.client.SuggestionManager;
import org.netbeans.modules.tasklist.client.SuggestionPerformer;
import org.netbeans.modules.tasklist.providers.DocumentSuggestionProvider;
import org.netbeans.modules.tasklist.providers.SuggestionContext;
import org.netbeans.modules.tasklist.javadoc.ext.JavadocProxy;


/**
 * This class lists the javadoc errors for the current document/class
 * <p>
 *
 * @todo Add Confirmation panels
 *
 * @todo Look at performance. Rewrite the ListModel stuff.
 *    Or find a way to reuse the javadoc module AutoCommenter directly.
 *
 * @todo Handle the case where a formal parameter has been renamed
 *   better. Instead of offering one action to delete the
 * javadoc and another to add for the new name, have some kind
 * of rename-mapping. For example, the confirmation dialog
 * could ask you to select among existing items instead (where
 * I list undocumented parameters)
 *
 * @todo Try to position the cursor better: if you double click on a
 *  "@param is missing description" error, don't go to the front of
 *  the javadoc comment - go to the line with the particular @param!
 *
 * @todo Even though I list javadoc errors as separate suggestions,
 *  the fixer will apply ALL suggestions for the same method in
 *  on operation. This means the user doesn't get to select one
 *  and not all of the suggestions. This should be fixed, but requires
 *  some rearchitecting of the autoCorrect function in auto-commenter.
 *  Short term, I should at least remove the other suggestions after
 *  fix! 
 *
 * @author Tor Norbye
 */
public final class DocSuggester extends DocumentSuggestionProvider {
    public static final String TYPE = "nb-javadoc-errors"; // NOI18N
    
    /** The list of tasks we're currently showing in the tasklist */
    private List showingTasks = null;
    
    public String getType() {
        return TYPE;
    }
    
    public List scan(final SuggestionContext env) {

        if (SuggestionManager.getDefault().isEnabled(TYPE)) {
            return JavadocProxy.findErrors(env);
        } else {
            return null;
        }
    }

}
