package org.netbeans.modules.tasklist.javadoc;

import org.openide.src.ElementFormat;
import org.openide.src.FieldElement;
import org.openide.src.JavaDoc;
import org.openide.src.SourceException;
import org.netbeans.modules.tasklist.javadoc.ext.JavaTagNames;

public class AutoCommenterField extends AutoCommenterElement {

    private static final String[] NOT_PERMITTED_TAGS = {
        JavaTagNames.TAG_AUTHOR,
        JavaTagNames.TAG_EXCEPTION,
        JavaTagNames.TAG_PARAM,
        JavaTagNames.TAG_RETURN,
        JavaTagNames.TAG_SERIALDATA,
        JavaTagNames.TAG_THROWS,
        JavaTagNames.TAG_VERSION
    };

    private static final ElementFormat nameFormat = new ElementFormat( "{m} {t} {n}" ); // NOI18N

    public AutoCommenterField( FieldElement element ) {
        super( element );
    }

    JavaDoc getJavaDoc() {
        return ((FieldElement)srcElement).getJavaDoc();
    }

    String[] getNotPermittedTags() {
        return NOT_PERMITTED_TAGS;
    }

    String typeToString() {
        return "field"; // NOI18N
    }

    boolean elementTagsOk() {
        boolean error = false;
        if (this.isMultipleTags(JavaTagNames.TAG_SERIAL)) {
            error = true;
        }

        return !error;
    }

    void autoCorrect() throws SourceException {
        super.autoCorrect( getJavaDoc() );
    }

    boolean isCorrectable() {
        return super.isCorrectable();
    }

    ElementFormat getNameFormat () {
        return nameFormat;
    }
}
