package org.netbeans.modules.tasklist.javadoc;

import java.util.ArrayList;
import org.openide.src.ConstructorElement;
import org.openide.src.ElementFormat;
import org.openide.src.Identifier;
import org.openide.src.JavaDoc;
import org.openide.src.JavaDocSupport;
import org.openide.src.JavaDocTag;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.util.NbBundle;
import org.netbeans.modules.tasklist.javadoc.ext.JavaTagNames;

public class AutoCommenterConstructor extends AutoCommenterElement {
    private static final String[] NOT_PERMITTED_TAGS = {
        JavaTagNames.TAG_AUTHOR,
        JavaTagNames.TAG_SERIAL,
        JavaTagNames.TAG_SERIALFIELD,
        JavaTagNames.TAG_VERSION,
        JavaTagNames.TAG_RETURN
    };

    private static final ElementFormat nameFormat = new ElementFormat( "{m} {n} ( {p} )" ); // NOI18N

    public AutoCommenterConstructor( ConstructorElement element ) {
        super( element );
    }

    JavaDoc getJavaDoc() {
        return ((ConstructorElement)srcElement).getJavaDoc();
    }

    String[] getNotPermittedTags() {
        return NOT_PERMITTED_TAGS;
    }

    String typeToString() {
        return "constructor"; // NOI18N
    }

    boolean elementTagsOk() {
        return elementTagsOk( null, false );
    }


    boolean elementTagsOk( ArrayList correctedTags, boolean checkOnly ) {

        boolean error = false;

        // Check param tags

        JavaDocTag.Param[] ptags = ((ConstructorElement)srcElement).getJavaDoc().getParamTags();
        boolean[] ptags_found = new boolean[ ptags.length ];
        MethodParameter[] params = ((ConstructorElement)srcElement).getParameters();
        //boolean[] params_ok = new boolean[ params.length ];

        // Check if all parameters for the method are in the javadoc
        // and if there are any parameter tag duplicates.
        for (int j = 0 ; j < params.length ; j++) {
            boolean tagFound = false;
            boolean duplicateTagAlreadyFound = false;
            for (int i = 0 ; i < ptags.length ; i++) {
                if ( ptags[i].parameterName() != null && ptags[i].parameterName().equals( params[j].getName() ) ) {
                    ptags_found[i] = true;
                    if (!tagFound) {
                        tagFound = true;
                    } else if (! duplicateTagAlreadyFound) {
                        if ( checkOnly ) {
                            return false;
                        }
                        else if ( correctedTags == null ) {
                            errorList.add(NbBundle.getMessage(AutoCommenter.class, "ERR_DuplicatedParamTag", params[j].getName()));
                            resolutionList.add(NbBundle.getMessage(AutoCommenter.class, "FIX_DuplicatedParamTag", params[j].getName()));
// XXX Do a better job than simply picking the first one! List them here and let user pick!
                        }
                        error = true;
                        duplicateTagAlreadyFound = true;
                    }
                }
            }

            if (! tagFound ) {
                if ( checkOnly ) {
                    return false;
                } else if ( correctedTags == null ) {
                    error = true;
                    errorList.add(NbBundle.getMessage(AutoCommenter.class, "ERR_NoTagForParam", params[j].getName()));
                    resolutionList.add(NbBundle.getMessage(AutoCommenter.class, "FIX_NoTagForParam", params[j].getName()));
                }
                else {
                    correctedTags.add( JavaDocSupport.createParamTag( JavaTagNames.TAG_PARAM, params[j].getName() ) );
                }
            }
        }

        for( int i = 0; i < ptags.length; i++ ) {
            if ( !ptags_found[i] ) {
                if ( checkOnly ) {
                    return false;
                }
                else if ( correctedTags == null ) {
                    errorList.add( NbBundle.getMessage(AutoCommenter.class,"ERR_NoSuchParam", ptags[i].name(), ptags[i].parameterName()));
                    resolutionList.add(NbBundle.getMessage(AutoCommenter.class, "FIX_NoSuchParam", ptags[i].name(), ptags[i].parameterName()));
                }
                error = true;
            }
            else if ( correctedTags != null ) {
                correctedTags.add( ptags[i] );
            }


        }
        // Check throws tags


        JavaDocTag.Throws[] ttags = ((ConstructorElement)srcElement).getJavaDoc().getThrowsTags();
        boolean[] ttags_found = new boolean[ ttags.length ];
        Identifier[] excs = ((ConstructorElement)srcElement).getExceptions();
        //boolean[] excs_ok = new boolean[ excs.length ];

        // Check if all exceptions for the method are in the javadoc
        // and if there are any exception tag duplicates.
        for (int j = 0 ; j < excs.length ; j++) {
            boolean tagFound = false;
            boolean duplicateTagAlreadyFound = false;
            for (int i = 0 ; i < ttags.length ; i++) {
                // if ( ttags[i].exceptionName() != null && ttags[i].exceptionName().equals( excs[j].getName() ) ) {
                Identifier tagExId = Identifier.create(ttags[i].exceptionName() );
                if ( tagExId != null && ( tagExId.compareTo( excs[j], false ) ||
                          tagExId.getName().equals(excs[j].getName() ) ) ) {                        
                    ttags_found[i] = true;
                    if (!tagFound) {
                        tagFound = true;
                    } else if (! duplicateTagAlreadyFound){
                        if ( checkOnly ) {
                            return false;
                        }
                        else if ( correctedTags == null ) {
                            errorList.add(NbBundle.getMessage(AutoCommenter.class, "ERR_DuplicatedExceptionTag", excs[j].getName()));
                            resolutionList.add(NbBundle.getMessage(AutoCommenter.class, "FIX_DuplicatedExceptionTag", excs[j].getName()));
                        }
                        error = true;
                        duplicateTagAlreadyFound = true;
                    }
                }
            }

            if (! tagFound ) {
                if ( checkOnly ) {
                    return false;
                } else if ( correctedTags == null ) {
                    error = true;
                    errorList.add( NbBundle.getMessage(AutoCommenter.class, "ERR_NoTagForException", excs[j].getName() ));
                    resolutionList.add(NbBundle.getMessage(AutoCommenter.class, "FIX_NoTagForException", excs[j].getName()));
                }
                else {
                    correctedTags.add( JavaDocSupport.createThrowsTag( JavaTagNames.TAG_THROWS, excs[j].getName() ) );
                }
            }
        }

        for( int i = 0; i < ttags.length; i++ ) {
            if ( !ttags_found[i] ) {
                if ( checkOnly ) {
                    return false;
                }
                else if ( correctedTags == null ) {
                    errorList.add( NbBundle.getMessage(AutoCommenter.class, "ERR_NoSuchException", ttags[i].name(), ttags[i].exceptionName()));
                    resolutionList.add(NbBundle.getMessage(AutoCommenter.class, "FIX_NoSuchException", ttags[i].name(), ttags[i].exceptionName()));
                }
                error = true;
            }
            else if ( correctedTags != null ) {
                correctedTags.add( ttags[i] );
            }


        }

        return !error;
    }

    boolean isCorrectable () {
        if ( super.isCorrectable() )
            return true;

        return !elementTagsOk( null, true );
    }

    void autoCorrect() throws SourceException {
        autoCorrect( getJavaDoc() );
    }

    void autoCorrect( JavaDoc jDoc ) throws SourceException {
        JavaDoc.Method jdTemp = JavaDocSupport.createMethodJavaDoc(getJavaDoc().getRawText());

        // create comment without throws and params

        JavaDocTag tags[] = jdTemp.getTags();
        ArrayList stdTags = new ArrayList( tags.length );

        for( int i = 0; i < tags.length; i++ ) {
            if ( !( tags[i] instanceof JavaDocTag.Param ) &&
                    !( tags[i] instanceof JavaDocTag.Throws ) ) {
                stdTags.add( tags[i] );
            }
        }

        // jdTemp.setRawText( generateRawText( jdTemp.getText(), stdTags ) );
        jdTemp.changeTags( (JavaDocTag[])stdTags.toArray( new JavaDocTag[ stdTags.size() ] ), JavaDoc.SET  );

        super.autoCorrect( jdTemp );

        ArrayList correctedTags = new ArrayList();
        elementTagsOk( correctedTags, false );

        // Build all tags collection

        ArrayList allTags = new ArrayList( correctedTags.size() + tags.length );
        tags = jdTemp.getTags();
        for( int i = 0; i < tags.length; i++ ) {
            allTags.add( tags[i] );
        }
        allTags.addAll( correctedTags );

        /*
        Iterator it = allTags.iterator(); 
        while( it.hasNext() ) {
          System.out.println( (JavaDocTag)it.next() );
    }
        */
        //getJavaDoc().setRawText( generateRawText( jdTemp.getText(), allTags ) );
        jDoc.changeTags( (JavaDocTag[])allTags.toArray( new JavaDocTag[ allTags.size() ] ), JavaDoc.SET  );
    }

    ElementFormat getNameFormat () {
        return nameFormat;
    }
}
