/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.websphere6.util;

/**
 * The central debugging utility for the plugin. The plugin whould forward all
 * the debugging information to this tool, which will output it to System.err
 * if the debug has been enabled
 * 
 * @author Kirill Sorokin
 */
public class WSDebug {
    
    /**
     * The name of the system property that should be present in order to
     * enable the debugging output for the plugin
     */
    private static final String PROPERTY = "j2eeplugins.websphere6.debug";
    
    /**
     * The prefix that should be inserted before any messages that are output
     * by this class
     */
    private static final String PREFIX = "j2eeplugins.websphere6 --- ";
    
    /**
     * Indicated whether the debug is enabled. At initialization we check for 
     * the presence of the "j2eeplugins.websphere6.debug" property and if it is 
     * present we consider the debug for the plugin enabled.
     */
    private static boolean isEnabled = System.
            getProperty(PROPERTY) != null;                             // NOI18N
    
    /**
     * Tells whether the debug for the plugin is enabled
     */
    public static boolean isEnabled() {
        return isEnabled;
    }
    
    /**
     * Outputs the given message to the System.err with the fixed prefix
     *
     * @param message the message to be output
     */
    public static void notify(String message) {
        System.err.println(PREFIX + message);   // NOI18N
    }
    
    /**
     * Outputs the given message to the System.err with the fixed prefix and the
     * class name
     * 
     * @param clazz the class from which the message originated
     * @param message the message to be output
     */
    public static void notify(Class clazz, String message) {
        System.err.println("j2eeplugins.websphere6 --- [" +            // NOI18N
                clazz.getName() + "]: " + message);                    // NOI18N
    }
    
    /**
     * Outputs the given exception to the System.err
     * 
     * @param exception the exception
     */
    public static void notify(Exception exception) {
        exception.printStackTrace(System.err);
    }
    
    /**
     * Outputs the supplied pack of objects to the System.err
     * 
     * @param objects an array of objects that need to be output
     */
    public static void notify(Object[] objects) {
        System.err.println(PREFIX + objects);
        for (int i = 0; i < objects.length; i++) {
            System.err.println(PREFIX + objects[i]);
        }
    }
    
    /**
     * Prints the current stack to the System.err
     */
    public static void printStack() {
        // get the stack trace
        StackTraceElement[] stack = new Exception().getStackTrace();
        
        // for each stack element output import to the System.err
        for (int i = 3; i < stack.length; i++) {
            System.err.println(PREFIX +         // NOI18N
                    stack[i]); 
        }
    }
    
}
