/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.websphere6;

import javax.enterprise.deploy.model.*;
import javax.enterprise.deploy.shared.*;

/**
 * Wrapper for the j2eeserver's implementation of J2eeApplicationObject. This 
 * class extends WSdeployableObject and all the altered logic goes in there, 
 * thus here we only delegate the calls to the j2eeserver's object
 * 
 * @author Kirill Sorokin
 */
public class WSJ2eeApplicationObject extends WSDeployableObject 
        implements J2eeApplicationObject {
    
    /**
     * Handle for the j2eeserver's implementation
     */
    private J2eeApplicationObject j2eeApplicationObject;
    
    /**
     * Creates a new instance of WSJ2eeApplicationObject.
     * 
     * @param j2eeApplicationObject the j2eeserver's implementation
     */
    public WSJ2eeApplicationObject(
            J2eeApplicationObject j2eeApplicationObject) {
        // call the WSdeployableObject's constructor
        super(j2eeApplicationObject);
        
        // save the supplied object
        this.j2eeApplicationObject = j2eeApplicationObject;
    }
    
    /**
     * Delegates the call to the j2eeserver's implementation, returning the
     * result if necessary.
     */
    public void addXpathListener(ModuleType moduleType, String str, 
            XpathListener xpathListener) {
        j2eeApplicationObject.addXpathListener(moduleType, str, xpathListener);
    }

    /**
     * Delegates the call to the j2eeserver's implementation, returning the
     * result if necessary.
     */
    public void removeXpathListener(ModuleType moduleType, String str, 
            XpathListener xpathListener) {
        j2eeApplicationObject.removeXpathListener(moduleType, str, 
                xpathListener);
    }
    
    /**
     * Delegates the call to the j2eeserver's implementation, returning the
     * result if necessary.
     */
    public String[] getModuleUris(ModuleType moduleType) {
        return j2eeApplicationObject.getModuleUris(moduleType);
    }
    
    /**
     * Delegates the call to the j2eeserver's implementation, returning the
     * result if necessary.
     */
    public DeployableObject[] getDeployableObjects() {
        return j2eeApplicationObject.getDeployableObjects();
    }

    /**
     * Delegates the call to the j2eeserver's implementation, returning the
     * result if necessary.
     */
    public DeployableObject getDeployableObject(String str) {
        return j2eeApplicationObject.getDeployableObject(str);
    }
    
    /**
     * Delegates the call to the j2eeserver's implementation, returning the
     * result if necessary.
     */
    public DeployableObject[] getDeployableObjects(ModuleType moduleType) {
        return j2eeApplicationObject.getDeployableObjects(moduleType);
    }

    /**
     * Delegates the call to the j2eeserver's implementation, returning the
     * result if necessary.
     */
    public String[] getText(ModuleType moduleType, String str) {
        return j2eeApplicationObject.getText(moduleType, str);
    }

    /**
     * Delegates the call to the j2eeserver's implementation, returning the
     * result if necessary.
     */
    public DDBean[] getChildBean(ModuleType moduleType, String str) {
        return j2eeApplicationObject.getChildBean(moduleType, str);
    }

    /**
     * Delegates the call to the j2eeserver's implementation, returning the
     * result if necessary.
     */
    public String[] getModuleUris() {
        return j2eeApplicationObject.getModuleUris();
    }
    
}
