/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.websphere6;

import javax.enterprise.deploy.model.*;
import javax.enterprise.deploy.shared.*;

/**
 * Wrapper for the j2eeserver's implementation of <code>DDBeanRoot</code>.
 * This class serves as a wrapper for j2eeserver's implementation of 
 * <code>DDBeanRoot</code> that fixes its incompartibility with the 
 * JSR-88 specification. The j2eeserver's implementation returns 
 * <i>'/&lt;app-type&gt;'</i> as its xpath, while the specification requires
 * the xpath to be <i>'/'</i>.
 * 
 * @author Kirill Sorokin
 */
public class WSDDBeanRoot implements DDBeanRoot {
    /**
     * The original j2eeserver's <code>DDBeanRoot</code> implementation, all
     * operations except <code>getXpath()</code> and 
     * <code>getDeployableObject</code> are delegated to it
     */
    private DDBeanRoot bean;
    
    /**
     * Handle for the plugin's <code>DeployableObject</code> wrapper, it is 
     * used in the <code>getDeploaybleObject()</code> call
     */
    private WSDeployableObject parentObject;
    
    /**
     * Creates a new instance of <code>WSDDBeanRoot</code>
     * 
     * @param bean the original j2eeserver's <code>DDBeanRoot</code> 
     *      implementation
     * @param parentObject the plugin's parent <code>DeployableObject</code> 
     *      wrapper
     */
    public WSDDBeanRoot(DDBeanRoot bean, WSDeployableObject parentObject) {
        // save the instance variables
        this.bean = bean;
        this.parentObject = parentObject;
    }
    
    /**
     * Returns the original j2eeserver's <code>DDBeanRoot</code> implementation
     * object
     * 
     * @return the original j2eeserver's DDBeanRoot
     */
    public DDBeanRoot getOrigin() {
        return bean;
    }
    
    /**
     * Returns the specification compliant <code>DDBeanRoot</code>'s xpath, 
     * i.e. <i>'/'</i>
     * 
     * @return string containing the correct DDBeanRoot's xpath, i.e. <i>'/'</i>
     */
    public String getXpath() {
        return "/";                                                    // NOI18N
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    public String getAttributeValue(String str) {
        return bean.getAttributeValue(str);
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    public DDBean[] getChildBean(String str) {
        return bean.getChildBean(str);
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    public String[] getText(String str) {
        return bean.getText(str);
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    public void removeXpathListener(String str, XpathListener xpathListener) {
        bean.removeXpathListener(str, xpathListener);
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    public void addXpathListener(String str, XpathListener xpathListener) {
        bean.addXpathListener(str, xpathListener);
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    public String[] getAttributeNames() {
        return bean.getAttributeNames();
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    public String getDDBeanRootVersion() {
        return bean.getDDBeanRootVersion();
    }
    
    /**
     * Returns the parent <code>DeployableObject</code> object, currently a 
     * plugin wrapper for the j2eeserver's implementation
     * 
     * @return parent <code>DeployableObject</code> implementation
     */
    public DeployableObject getDeployableObject() {
        return parentObject;
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    public String getFilename() {
        return bean.getFilename();
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    public String getId() {
        return bean.getId();
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    public String getModuleDTDVersion() {
        return bean.getDDBeanRootVersion();
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    public DDBeanRoot getRoot() {
        return bean.getRoot();
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    public String getText() {
        return bean.getText();
    }
    
    /**
     * Delegates the call to the j2eeserver's <code>DDBeanRoot</code> 
     * implementation object.
     */
    public ModuleType getType() {
        return bean.getType();
    }
}