/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * WS70ConfigurationSupportImpl.java
 * Reused from Appserver 81 
 */

package org.netbeans.modules.j2ee.sun.ws7.j2ee;

import java.io.File;

import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;

import org.netbeans.modules.j2ee.deployment.common.api.OriginalCMPMapping;
import org.netbeans.modules.j2ee.deployment.plugins.api.ConfigurationSupport;

import org.netbeans.modules.j2ee.sun.share.configbean.EjbJarRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;


/** Implementation of ConfigurationSupport.
 *
 *  Primarily serves to delegate directly to the specified DeploymentConfiguration
 *  instance, as that is in shared code and has appropriate access and this instance
 *  is not.
 *  Reused from Sun Java System Appserver 81 plugin
 */
public class WS70ConfigurationSupportImpl extends ConfigurationSupport {

    /** Creates a new instance of ConfigurationSupport */
    public WS70ConfigurationSupportImpl() {
    }

    
    /** Called by j2eeserver to initialize the deployment configuration object
     *  for this J2EE project.
     */
    public void initConfiguration(DeploymentConfiguration config, File[] files, File resourceDir, boolean keepUpdated) throws ConfigurationException {
        checkConfiguration(config);
        if(files == null || files.length == 0) {
            throw new IllegalArgumentException("Invalid value of the files argument.");
        }
        ((SunONEDeploymentConfiguration)config).init(files, resourceDir, keepUpdated);
    }    

    
    /** Called by j2eeserver to allow us to cleanup the deployment configuration object
     *  for this J2EE project.
     */
    public void disposeConfiguration(DeploymentConfiguration config) {
        checkConfiguration(config);
        ((SunONEDeploymentConfiguration)config).dispose();
    }

    
    /** Called through j2eeserver when a new resource may need to be added to the
     *  user's project.
     */
    public void ensureResourceDefined(DeploymentConfiguration config, DDBean ddBean) {
        checkConfiguration(config);
        if(ddBean == null) {
            throw new IllegalArgumentException("DDBean parameter cannot be null.");
        }
        ((SunONEDeploymentConfiguration)config).ensureResourceDefined(ddBean);
    }

    
    /** Conduit to pass the cmp mapping information directly to the configuration
     *  backend.
     */
    public void setMappingInfo(DeploymentConfiguration config, OriginalCMPMapping[] mapping){
        checkConfiguration(config);
        SunONEDeploymentConfiguration s1config = (SunONEDeploymentConfiguration) config;
        EjbJarRoot ejbJarRoot = s1config.getEjbJarRoot();
        if(ejbJarRoot != null) {
            ejbJarRoot.mapCmpBeans(mapping);
        }
    }


    /** Retrieves the context root field from sun-web.xml for this module, if the module is a
     *  web application.  Otherwise, returns null.
     */
    public String getWebContextRoot(DeploymentConfiguration config, DeployableObject deplObj) throws ConfigurationException {
        checkConfiguration(config);
        assert config.getDeployableObject() == deplObj;
        return ((SunONEDeploymentConfiguration)config).getContextRoot();
    }

    
    /** Sets the context root field in sun-web.xml for this module, if the module is a
     *  web application.
     */
    public void setWebContextRoot(DeploymentConfiguration config, DeployableObject deplObj, String contextRoot) throws ConfigurationException {
        checkConfiguration(config);
        assert config.getDeployableObject() == deplObj;
        ((SunONEDeploymentConfiguration)config).setContextRoot(contextRoot);
    }
    
    
    /** Updates the resource dir in use by this project.
     */
    public void updateResourceDir(DeploymentConfiguration config, File resourceDir) {
        checkConfiguration(config);
        ((SunONEDeploymentConfiguration) config).updateResourceDir(resourceDir);
    }
    
    /** Utility method to validate the configuration object being passed to the
     *  other methods in this class.
     */
    private void checkConfiguration(DeploymentConfiguration config) {
        if(config == null) {
            throw new IllegalArgumentException("DeploymentConfiguration is null");
        }
        if(!(config instanceof SunONEDeploymentConfiguration)) {
            throw new IllegalArgumentException("Wrong DeploymentConfiguration instance " + config.getClass().getName());
        }
    }
}

