/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.templates;

import java.io.File;
import javax.swing.JPanel;

import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;


/*
 *
 * @author Peter Williams
 */
public final class SunDDVisualPanel extends JPanel {
    
    private Project project;
    private String sunDDFileName;
    private File sunDDFile;
    private File sunDDLocation;

    public SunDDVisualPanel() {
        initComponents();
    }

    void setProject(final Project project) {
        this.project = project;

        // get j2ee module provider
        // get list of config files for this module type
        // figure out which ones exist already
        // 
        Lookup lookup = project.getLookup();
        J2eeModuleProvider provider = (J2eeModuleProvider) lookup.lookup(J2eeModuleProvider.class);
        J2eeModule j2eeModule = provider.getJ2eeModule();
        sunDDFileName = getConfigFileName(j2eeModule);

        // Calculate location:
        sunDDFile = (sunDDFileName != null) ? provider.getDeploymentConfigurationFile(sunDDFileName) : null;
        sunDDLocation = (sunDDFile != null) ? sunDDFile.getParentFile() : null;
        
        // initialize visual components
        textFileName.setText(sunDDFileName); // NOI18N
        textProjectName.setText(ProjectUtils.getInformation(project).getDisplayName());

        File projectFolder = FileUtil.toFile(project.getProjectDirectory());
        textLocation.setText((sunDDLocation != null) ? getRelativePath(sunDDLocation, projectFolder) : null);
        // only fill 'created file' in if location is valid.
        textCreatedFile.setText((sunDDLocation != null) ? getRelativePath(sunDDFile, projectFolder) : null);
    }
    
    String getFileName() {
        return sunDDFileName;
    }
    
    File getFile() {
        return sunDDFile;
    }
    
    File getSelectedLocation() {
        return sunDDLocation;
    }
    
    public String getName() {
        return NbBundle.getMessage(SunDDVisualPanel.class, "LBL_CreateSunDeploymentDescriptor"); // NOI18N
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        labelFileName = new javax.swing.JLabel();
        textFileName = new javax.swing.JTextField();
        labelProjectName = new javax.swing.JLabel();
        textProjectName = new javax.swing.JTextField();
        labelLocation = new javax.swing.JLabel();
        textLocation = new javax.swing.JTextField();
        labelCreatedFile = new javax.swing.JLabel();
        textCreatedFile = new javax.swing.JTextField();
        filler1 = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        labelFileName.setDisplayedMnemonic(org.openide.util.NbBundle.getMessage(SunDDVisualPanel.class, "MNE_Name").charAt(0));
        labelFileName.setLabelFor(textFileName);
        org.openide.awt.Mnemonics.setLocalizedText(labelFileName, org.openide.util.NbBundle.getMessage(SunDDVisualPanel.class, "LBL_Name"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(labelFileName, gridBagConstraints);

        textFileName.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 0);
        add(textFileName, gridBagConstraints);
        textFileName.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(SunDDVisualPanel.class, "ASCN_Name"));
        textFileName.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(SunDDVisualPanel.class, "ASCD_Name"));

        labelProjectName.setDisplayedMnemonic(org.openide.util.NbBundle.getMessage(SunDDVisualPanel.class, "MNE_Project").charAt(0));
        labelProjectName.setLabelFor(textProjectName);
        org.openide.awt.Mnemonics.setLocalizedText(labelProjectName, org.openide.util.NbBundle.getMessage(SunDDVisualPanel.class, "LBL_Project"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(labelProjectName, gridBagConstraints);

        textProjectName.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 0);
        add(textProjectName, gridBagConstraints);
        textProjectName.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(SunDDVisualPanel.class, "ASCN_Project"));
        textProjectName.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(SunDDVisualPanel.class, "ASCD_Project"));

        labelLocation.setDisplayedMnemonic(org.openide.util.NbBundle.getMessage(SunDDVisualPanel.class, "MNE_Location").charAt(0));
        labelLocation.setLabelFor(textLocation);
        org.openide.awt.Mnemonics.setLocalizedText(labelLocation, org.openide.util.NbBundle.getMessage(SunDDVisualPanel.class, "LBL_Location"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(labelLocation, gridBagConstraints);

        textLocation.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 0);
        add(textLocation, gridBagConstraints);
        textLocation.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(SunDDVisualPanel.class, "ASCN_Location"));
        textLocation.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(SunDDVisualPanel.class, "ASCD_Location"));

        labelCreatedFile.setDisplayedMnemonic(org.openide.util.NbBundle.getMessage(SunDDVisualPanel.class, "MNE_CreatedFile").charAt(0));
        labelCreatedFile.setLabelFor(textCreatedFile);
        org.openide.awt.Mnemonics.setLocalizedText(labelCreatedFile, org.openide.util.NbBundle.getMessage(SunDDVisualPanel.class, "LBL_CreatedFile"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 11, 0);
        add(labelCreatedFile, gridBagConstraints);

        textCreatedFile.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 11, 0);
        add(textCreatedFile, gridBagConstraints);
        textCreatedFile.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(SunDDVisualPanel.class, "ASCN_CreatedFile"));
        textCreatedFile.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(SunDDVisualPanel.class, "ASCD_CreatedFile"));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(filler1, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel filler1;
    private javax.swing.JLabel labelCreatedFile;
    private javax.swing.JLabel labelFileName;
    private javax.swing.JLabel labelLocation;
    private javax.swing.JLabel labelProjectName;
    private javax.swing.JTextField textCreatedFile;
    private javax.swing.JTextField textFileName;
    private javax.swing.JTextField textLocation;
    private javax.swing.JTextField textProjectName;
    // End of variables declaration//GEN-END:variables
    

    private String getConfigFileName(J2eeModule j2eeModule) {
        String result = null;
        Object moduleType = j2eeModule.getModuleType();
        if(J2eeModule.WAR.equals(moduleType)) {
            result = "sun-web.xml"; // NOI18N
        } else if(J2eeModule.EJB.equals(moduleType)) {
            result = "sun-ejb-jar.xml"; // NOI18N
        } else if(J2eeModule.EAR.equals(moduleType)) {
            result = "sun-application.xml"; // NOI18N
        } else if(J2eeModule.CLIENT.equals(moduleType)) {
            result = "sun-application-client.xml"; // NOI18N
        }
        return result;
    }
    
    private static String getRelativePath(File file, File base) {
        String basePath = base.getAbsolutePath();
        String filePath = file.getAbsolutePath();
        
        if(filePath.startsWith(basePath)) {
            String prefix = "";
            int baseIndex = basePath.lastIndexOf(File.separatorChar);
            if(baseIndex < 0 || baseIndex >= filePath.length()) {
                baseIndex = 0;
            } else {
                prefix = "..."; // only apply prefix if we're calculating a true substring.
            }
            return prefix + filePath.substring(baseIndex);
        }
        return filePath;
    }
    
}
