/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * ServiceRefPortInfoPanel.java
 *
 * Created on November 2, 2003, 10:28 AM
 */

package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice;

import java.util.List;
import java.util.Iterator;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyVetoException;

import javax.swing.JPanel;
import javax.swing.DefaultComboBoxModel;

import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.dd.api.common.PortInfo;

import org.netbeans.modules.j2ee.sun.share.configbean.ServiceRef;
import org.netbeans.modules.j2ee.sun.share.configbean.StorageBeanFactory;

/**
 *
 * @author Peter Williams
 */
public class ServiceRefPortInfoPanel extends JPanel {

	private ServiceRefCustomizer masterPanel;
	private SelectedPortInfoPanel selectedPortPanel;

	private DefaultComboBoxModel portInfoModel;

	/** Creates new form ServiceRefPortInfoPanel */
	public ServiceRefPortInfoPanel(ServiceRefCustomizer src) {
		masterPanel = src;

		initComponents();
		initUserComponents();
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLblPortInfoUsageDescription = new javax.swing.JLabel();
        jPnlPortInfoSelector = new javax.swing.JPanel();
        jLblPortInfo = new javax.swing.JLabel();
        jComboPortInfo = new javax.swing.JComboBox();
        jPnlPortInfoButtons = new javax.swing.JPanel();
        jBtnAddPortInfo = new javax.swing.JButton();
        jBtnRemovePortInfo = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        getAccessibleContext().setAccessibleName(ServiceRefCustomizer.bundle.getString("ACSN_PortInfoTab"));
        getAccessibleContext().setAccessibleDescription(ServiceRefCustomizer.bundle.getString("ACSD_PortInfoTab"));
        jLblPortInfoUsageDescription.setText(ServiceRefCustomizer.bundle.getString("LBL_ServicePortInfoDescription"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 5);
        add(jLblPortInfoUsageDescription, gridBagConstraints);

        jPnlPortInfoSelector.setLayout(new java.awt.GridBagLayout());

        jPnlPortInfoSelector.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jLblPortInfo.setLabelFor(jComboPortInfo);
        jLblPortInfo.setText(ServiceRefCustomizer.bundle.getString("LBL_PortInfo_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.ipady = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 0);
        jPnlPortInfoSelector.add(jLblPortInfo, gridBagConstraints);

        jComboPortInfo.setPrototypeDisplayValue("");
        jComboPortInfo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboPortInfoActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 0);
        jPnlPortInfoSelector.add(jComboPortInfo, gridBagConstraints);
        jComboPortInfo.getAccessibleContext().setAccessibleName(ServiceRefCustomizer.bundle.getString("ACSN_PortInfo"));
        jComboPortInfo.getAccessibleContext().setAccessibleDescription(ServiceRefCustomizer.bundle.getString("ACSD_PortInfo"));

        jPnlPortInfoButtons.setLayout(new java.awt.GridBagLayout());

        jBtnAddPortInfo.setText(ServiceRefCustomizer.bundle.getString("LBL_Add"));
        jBtnAddPortInfo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnAddPortInfoActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPnlPortInfoButtons.add(jBtnAddPortInfo, gridBagConstraints);
        jBtnAddPortInfo.getAccessibleContext().setAccessibleName(ServiceRefCustomizer.bundle.getString("ACSN_Add"));
        jBtnAddPortInfo.getAccessibleContext().setAccessibleDescription(ServiceRefCustomizer.bundle.getString("ACSD_Add"));

        jBtnRemovePortInfo.setText(ServiceRefCustomizer.bundle.getString("LBL_Remove"));
        jBtnRemovePortInfo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnRemovePortInfoActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        jPnlPortInfoButtons.add(jBtnRemovePortInfo, gridBagConstraints);
        jBtnRemovePortInfo.getAccessibleContext().setAccessibleName(ServiceRefCustomizer.bundle.getString("ACSN_Remove"));
        jBtnRemovePortInfo.getAccessibleContext().setAccessibleDescription(ServiceRefCustomizer.bundle.getString("ACSD_Remove"));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 5);
        jPnlPortInfoSelector.add(jPnlPortInfoButtons, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 5);
        add(jPnlPortInfoSelector, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents

	private void jBtnRemovePortInfoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnRemovePortInfoActionPerformed
		// Add your handling code here:
		int index = jComboPortInfo.getSelectedIndex();

		if(index != -1) {
			// FIXME do we want to put up a warning?
			try {
				PortInfoMapping portInfoMapping = (PortInfoMapping) jComboPortInfo.getSelectedItem();
				ServiceRef bean = masterPanel.getBean();
				if(bean != null) {
					bean.removePortInfo(portInfoMapping.getPortInfo());
				}
				jComboPortInfo.removeItemAt(index);
				enableButtonsAndPanels();

				if(portInfoModel.getSize() > 0) {
					jComboPortInfo.setSelectedIndex(0);
				} else {
					jComboPortInfo.setSelectedIndex(-1);
				}
			} catch(PropertyVetoException ex) {
			}
		}
	}//GEN-LAST:event_jBtnRemovePortInfoActionPerformed

	private void jBtnAddPortInfoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnAddPortInfoActionPerformed
		// Add your handling code here:
		try {
            StorageBeanFactory storageFactory = masterPanel.getBean().getConfig().getStorageFactory();
			PortInfoMapping portInfoMapping = new PortInfoMapping(storageFactory.createPortInfo(),
				ServiceRefCustomizer.bundle.getString("LBL_NewPortInfo"));	// NOI18N
			ServiceRef bean = masterPanel.getBean();
			if(bean != null) {
				bean.addPortInfo(portInfoMapping.getPortInfo());
			}
			jComboPortInfo.addItem(portInfoMapping);
			enableButtonsAndPanels();

			jComboPortInfo.setSelectedItem(portInfoMapping);
		} catch(PropertyVetoException ex) {
		}
	}//GEN-LAST:event_jBtnAddPortInfoActionPerformed

	private void jComboPortInfoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboPortInfoActionPerformed
		// Add your handling code here:
		PortInfoMapping portInfoMapping = (PortInfoMapping) portInfoModel.getSelectedItem();

		if(portInfoMapping != null) {
			selectedPortPanel.setPortInfoMapping(portInfoMapping);
		} else {
			selectedPortPanel.setPortInfoMapping(null);
		}
	}//GEN-LAST:event_jComboPortInfoActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jBtnAddPortInfo;
    private javax.swing.JButton jBtnRemovePortInfo;
    private javax.swing.JComboBox jComboPortInfo;
    private javax.swing.JLabel jLblPortInfo;
    private javax.swing.JLabel jLblPortInfoUsageDescription;
    private javax.swing.JPanel jPnlPortInfoButtons;
    private javax.swing.JPanel jPnlPortInfoSelector;
    // End of variables declaration//GEN-END:variables

	private void initUserComponents() {
		/** Add selected port panel */
		selectedPortPanel = new SelectedPortInfoPanel(masterPanel);

        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
		gridBagConstraints.insets = new Insets(0, 6, 5, 5);
        add(selectedPortPanel, gridBagConstraints);
	}

	/** Initialization of all the fields in this panel from the bean that
	 *  was passed in.
	 */
	public void initFields(ServiceRef bean) {
		// FIXME set combobox to proper value
		portInfoModel = new DefaultComboBoxModel();
		List portInfoList = bean.getPortInfos();
		if(portInfoList != null) {
			Iterator iter = portInfoList.iterator();
			while(iter.hasNext()) {
				PortInfo pi = (PortInfo) iter.next();
				portInfoModel.addElement(new PortInfoMapping(pi));
			}
		}
		jComboPortInfo.setModel(portInfoModel);

		if(portInfoModel.getSize() > 0) {
			jComboPortInfo.setSelectedIndex(0);
		}

		enableButtonsAndPanels();
	}
	
	protected void addListeners(ServiceRef bean) {
	}

	protected void removeListeners(ServiceRef bean) {
	}	

	private void enableButtonsAndPanels() {
		boolean enabled = (portInfoModel.getSize() > 0);
		jComboPortInfo.setEnabled(enabled);
		jBtnRemovePortInfo.setEnabled(enabled);
		selectedPortPanel.setContainerEnabled(selectedPortPanel, enabled);
	}
}
