/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * WebAppCachePanel.java
 *
 * Created on November 5, 2003, 4:56 PM
 */

package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp;

import java.util.ResourceBundle;

import javax.swing.JTabbedPane;

import org.netbeans.modules.j2ee.sun.share.configbean.ValidationError;
import org.netbeans.modules.j2ee.sun.share.configbean.WebAppRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.WebAppCache;

/**
 *
 * @author Peter Williams
 */
public class WebAppCachePanel extends JTabbedPane {
	
	private static final ResourceBundle webappBundle = ResourceBundle.getBundle(
		"org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.Bundle");	// NOI18N
		
	private WebAppRootCustomizer masterPanel;
	
	/** Creates new form WebAppCachePanel */
	public WebAppCachePanel(WebAppRootCustomizer src) {
		masterPanel = src;
		
		initComponents();
		initUserComponents();
	}
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    private void initComponents() {//GEN-BEGIN:initComponents

        setTabPlacement(javax.swing.JTabbedPane.BOTTOM);
        getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_WebAppCacheTab"));
        getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_WebAppCacheTab"));
    }//GEN-END:initComponents
	
	
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables

	private CacheGeneralPanel generalPanel;
	private CacheHelperPanel helperPanel;
	private CacheMappingPanel mappingPanel;
	
	private void initUserComponents() {
		// add cache general panel
		generalPanel = new CacheGeneralPanel(masterPanel);
		addTab(webappBundle.getString("CACHE_GENERAL_TAB"), generalPanel);	// NOI18N
		
		// add cache helper panel
		helperPanel = new CacheHelperPanel(masterPanel);
		addTab(webappBundle.getString("CACHE_HELPERS_TAB"), helperPanel);	// NOI18N
		
		// add cache mappings panel
		mappingPanel = new CacheMappingPanel(masterPanel);
		addTab(webappBundle.getString("CACHE_MAPPINGS_TAB"), mappingPanel);	// NOI18N
	}
	
	public void addListeners() {
		generalPanel.addListeners();
		helperPanel.addListeners();
		mappingPanel.addListeners();
	}
	
	public void removeListeners() {
		generalPanel.removeListeners();
		helperPanel.removeListeners();
		mappingPanel.removeListeners();		
	}	
	
	/** Initialization of all the fields in this panel from the bean that
	 *  was passed in.
	 */
	public void initFields(WebAppRoot theBean) {
		WebAppCache cacheBean = theBean.getCacheBean();
		generalPanel.initFields(cacheBean);
		helperPanel.initFields(cacheBean);
		mappingPanel.initFields(cacheBean);
	}
	
	/** Returns the help ID for the selected tab within the cache tab of sun-web-app.
	 *
	 * @return String representing the current active help ID for this tabbed panel.
	 */
	public String getHelpId() {
		String result = "AS_CFG_WebAppCacheGeneral";	// NOI18N
		
		// Determine which tab has focus and return help context for that tab.
		switch(getSelectedIndex()) {
			case 2:
				result = "AS_CFG_WebAppCacheMapping";	// NOI18N
				break;
			case 1:
				result = "AS_CFG_WebAppCacheHelpers";	// NOI18N
				break;
		}
		
		return result;
	}

	/** Retrieve the partition that should be associated with the current 
	 *  selected tab.
	 *
	 *  @return ValidationError.Partition
	 */
	public ValidationError.Partition getPartition() {
		switch(getSelectedIndex()) {
			case 2:
				return ValidationError.PARTITION_CACHE_CONSTRAINTS;
			case 1:
				return ValidationError.PARTITION_CACHE_HELPERS;
			default:
				return ValidationError.PARTITION_CACHE_GENERAL;
		}
	}	
}
