/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * CacheGeneralPanel.java
 *
 * Created on January 7, 2004, 5:10 PM
 */

package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp;

import java.util.ArrayList;
import java.util.ResourceBundle;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyVetoException;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

import org.netbeans.modules.j2ee.sun.dd.api.web.WebProperty;

import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.WebAppRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.WebAppCache;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTablePanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.HelpContext;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.DynamicPropertyPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.PropertyListMapping;

/**
 *
 * @author Peter Williams
 */
public class CacheGeneralPanel extends javax.swing.JPanel implements TableModelListener {
	
	private static final ResourceBundle webappBundle = ResourceBundle.getBundle(
		"org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.Bundle");	// NOI18N

	private static final ResourceBundle commonBundle = ResourceBundle.getBundle(
		"org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");	// NOI18N

	private WebAppRootCustomizer masterPanel;

	// Table for editing Cache Property web properties
	private GenericTableModel propertiesModel;
	private GenericTablePanel propertiesPanel;

	/** Creates new form CacheGeneralPanel */
	public CacheGeneralPanel(WebAppRootCustomizer src) {
		masterPanel = src;

		initComponents();
		initUserComponents();
	}
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPnlCacheGeneral = new javax.swing.JPanel();
        jLblCacheSettings = new javax.swing.JLabel();
        jChkCacheEnabled = new javax.swing.JCheckBox();
        jLblMaxEntries = new javax.swing.JLabel();
        jTxtMaxEntries = new javax.swing.JTextField();
        jLblTimeout = new javax.swing.JLabel();
        jTxtTimeout = new javax.swing.JTextField();

        setLayout(new java.awt.GridBagLayout());

        getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_CacheGeneralTab"));
        getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_CacheGeneralTab"));
        jPnlCacheGeneral.setLayout(new java.awt.GridBagLayout());

        jLblCacheSettings.setText(webappBundle.getString("LBL_CacheSettings"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        jPnlCacheGeneral.add(jLblCacheSettings, gridBagConstraints);

        jChkCacheEnabled.setText(webappBundle.getString("LBL_CacheEnabled"));
        jChkCacheEnabled.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jChkCacheEnabledItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 2, 0, 0);
        jPnlCacheGeneral.add(jChkCacheEnabled, gridBagConstraints);
        jChkCacheEnabled.getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_CacheEnabled"));
        jChkCacheEnabled.getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_CacheEnabled"));

        jLblMaxEntries.setLabelFor(jTxtMaxEntries);
        jLblMaxEntries.setText(webappBundle.getString("LBL_MaximumEntries_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        jPnlCacheGeneral.add(jLblMaxEntries, gridBagConstraints);

        jTxtMaxEntries.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jTxtMaxEntriesKeyReleased(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 5);
        jPnlCacheGeneral.add(jTxtMaxEntries, gridBagConstraints);
        jTxtMaxEntries.getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_MaximumEntries"));
        jTxtMaxEntries.getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_MaximumEntries"));

        jLblTimeout.setLabelFor(jTxtTimeout);
        jLblTimeout.setText(webappBundle.getString("LBL_Timeout_1"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 0);
        jPnlCacheGeneral.add(jLblTimeout, gridBagConstraints);

        jTxtTimeout.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jTxtTimeoutKeyReleased(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 5);
        jPnlCacheGeneral.add(jTxtTimeout, gridBagConstraints);
        jTxtTimeout.getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_Timeout"));
        jTxtTimeout.getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_Timeout"));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        add(jPnlCacheGeneral, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents

	private void jChkCacheEnabledItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jChkCacheEnabledItemStateChanged
		// Add your handling code here:
        WebAppRoot bean = masterPanel.getBean();
		if(bean != null) {
			WebAppCache cacheBean = bean.getCacheBean();
			try {
				boolean state = Utils.interpretCheckboxState(evt);
				cacheBean.setCacheEnabled(Boolean.toString(state));
			} catch(PropertyVetoException ex) {
				jChkCacheEnabled.setSelected(Utils.booleanValueOf(cacheBean.getCacheEnabled()));
			}
		}
	}//GEN-LAST:event_jChkCacheEnabledItemStateChanged

	private void jTxtMaxEntriesKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jTxtMaxEntriesKeyReleased
		// Add your handling code here:
        WebAppRoot bean = masterPanel.getBean();
		if(bean != null) {
			WebAppCache cacheBean = bean.getCacheBean();
			try {
				cacheBean.setCacheMaxEntries(jTxtMaxEntries.getText());
				cacheBean.validateField(WebAppCache.FIELD_CACHE_MAX_ENTRIES);
			} catch(PropertyVetoException ex) {
				jTxtMaxEntries.setText(cacheBean.getCacheMaxEntries());
			}
		}
	}//GEN-LAST:event_jTxtMaxEntriesKeyReleased

	private void jTxtTimeoutKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jTxtTimeoutKeyReleased
		// Add your handling code here:
        WebAppRoot bean = masterPanel.getBean();
		if(bean != null) {
			WebAppCache cacheBean = bean.getCacheBean();
			try {
				cacheBean.setTimeoutInSeconds(jTxtTimeout.getText());
				cacheBean.validateField(WebAppCache.FIELD_CACHE_TIMEOUT);
			} catch(PropertyVetoException ex) {
				jTxtTimeout.setText(cacheBean.getTimeoutInSeconds());
			}
		}
	}//GEN-LAST:event_jTxtTimeoutKeyReleased
		
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox jChkCacheEnabled;
    private javax.swing.JLabel jLblCacheSettings;
    private javax.swing.JLabel jLblMaxEntries;
    private javax.swing.JLabel jLblTimeout;
    private javax.swing.JPanel jPnlCacheGeneral;
    private javax.swing.JTextField jTxtMaxEntries;
    private javax.swing.JTextField jTxtTimeout;
    // End of variables declaration//GEN-END:variables
	
	private void initUserComponents() {
		/** Add properties table panel :
		 *  TableEntry list has three properties: Name, Value, Description
		 */
		ArrayList tableColumns = new ArrayList(3);
		tableColumns.add(new GenericTableModel.AttributeEntry(
			WebProperty.NAME, commonBundle.getString("LBL_Name"), true));	// NOI18N
		tableColumns.add(new GenericTableModel.AttributeEntry(
			WebProperty.VALUE, commonBundle.getString("LBL_Value"), true));	// NOI18N
		tableColumns.add(new GenericTableModel.ValueEntry(
			WebProperty.DESCRIPTION, commonBundle.getString("LBL_Description")));	// NOI18N		
		
		// add Property table
		propertiesModel = new GenericTableModel(WebAppRootCustomizer.webPropertyFactory, tableColumns);
		propertiesPanel = new GenericTablePanel(propertiesModel, 
			webappBundle, "CacheProperties",	// NOI18N - property name
			DynamicPropertyPanel.class, HelpContext.HELP_CACHE_PROPERTY_POPUP,
			PropertyListMapping.getPropertyList(PropertyListMapping.CACHE_PROPERTIES));
		
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 5);
		add(propertiesPanel, gridBagConstraints);
	}
	
	public void addListeners() {
		propertiesModel.addTableModelListener(this);
	}
	
	public void removeListeners() {
		propertiesModel.removeTableModelListener(this);
	}	
	
	/** Initialization of all the fields in this panel from the bean that
	 *  was passed in.
	 */
	public void initFields(WebAppCache cacheBean) {
		jTxtMaxEntries.setText(cacheBean.getCacheMaxEntries());
		jTxtTimeout.setText(cacheBean.getTimeoutInSeconds());
		jChkCacheEnabled.setSelected(Utils.booleanValueOf(cacheBean.getCacheEnabled()));
		
		propertiesPanel.setModel(cacheBean.getProperties(), cacheBean.getParent().getAppServerVersion());
	}
	
	/** ----------------------------------------------------------------------- 
	 *  Implementation of javax.swing.event.TableModelListener
	 */
	public void tableChanged(TableModelEvent e) {
		WebAppRoot bean = masterPanel.getBean();
		if(bean != null) {
			WebAppCache cacheBean = bean.getCacheBean();
			try {
				cacheBean.setProperties(propertiesModel.getData());
			
				// Force property change to be issued by the bean
				bean.setDirty();
			} catch(PropertyVetoException ex) {
				// FIXME undo whatever changed... how?

			}
		}		
	}
}
