/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * EjbJarPmDescriptorsPanel.java
 *
 * Created on November 5, 2003, 4:56 PM
 */

package org.netbeans.modules.j2ee.sun.share.configbean.customizers.ejbmodule;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyVetoException;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.dd.api.ejb.PmDescriptor;
import org.netbeans.modules.j2ee.sun.dd.api.ejb.PmDescriptors;
import org.netbeans.modules.j2ee.sun.dd.api.ejb.PmInuse;
import org.netbeans.modules.j2ee.sun.share.configbean.ASDDVersion;

import org.netbeans.modules.j2ee.sun.share.configbean.EjbJarRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.StorageBeanFactory;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTablePanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.HelpContext;
import org.openide.util.Utilities;

/**
 *
 * @author Peter Williams
 */
public class EjbJarPmDescriptorsPanel extends javax.swing.JPanel implements TableModelListener, ListDataListener {

    private static final ResourceBundle ejbjarBundle = ResourceBundle.getBundle(
        "org.netbeans.modules.j2ee.sun.share.configbean.customizers.ejbmodule.Bundle");	// NOI18N

    private EjbJarRootCustomizer masterPanel;

    private PmDescriptors pmDescriptors;

    private PmInUseCbxModel pmInUseModel;

    // Table for editing PM Descriptor entries
    private GenericTableModel pmDescriptorModel;
    private GenericTablePanel pmDescriptorPanel;

    /**
     * Creates new form EjbJarPmDescriptorsPanel
     */
    public EjbJarPmDescriptorsPanel(EjbJarRootCustomizer src) {
        masterPanel = src;

        initComponents();
        initUserComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLblPmInUse = new javax.swing.JLabel();
        jCbxPmInUse = new javax.swing.JComboBox();

        setLayout(new java.awt.GridBagLayout());

        getAccessibleContext().setAccessibleName(ejbjarBundle.getString("ACSN_PmDescriptorsTab"));
        getAccessibleContext().setAccessibleDescription(ejbjarBundle.getString("ACSD_PmDescriptorsTab"));
        jLblPmInUse.setLabelFor(jCbxPmInUse);
        jLblPmInUse.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("LBL_Pm_In_Use"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        add(jLblPmInUse, gridBagConstraints);

        jCbxPmInUse.setToolTipText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/share/configbean/customizers/ejbmodule/Bundle").getString("Pm_In_Use_Tool_Tip"));
        jCbxPmInUse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCbxPmInUseActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 5);
        add(jCbxPmInUse, gridBagConstraints);
        jCbxPmInUse.getAccessibleContext().setAccessibleName(ejbjarBundle.getString("Pm_In_Use_Acsbl_Name"));
        jCbxPmInUse.getAccessibleContext().setAccessibleDescription(ejbjarBundle.getString("Pm_In_Use_Acsbl_Desc"));

    }// </editor-fold>//GEN-END:initComponents

    private void jCbxPmInUseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCbxPmInUseActionPerformed
        updatePmInuse((PmDescriptorMapping) jCbxPmInUse.getSelectedItem());
    }//GEN-LAST:event_jCbxPmInUseActionPerformed
	
	private void updatePmInuse(PmDescriptorMapping mapping) {
        PmInuse oldPmInuse = pmDescriptors.getPmInuse();
        PmInuse newPmInuse = null;
        
        if(mapping == null || mapping.getPmDescriptor() == null) {
            pmDescriptors.setPmInuse(null);
        } else {
            PmDescriptor pmDescriptor = mapping.getPmDescriptor();
            String newPmIdentifier = pmDescriptor.getPmIdentifier();
            String newPmVersion = pmDescriptor.getPmVersion();
            
            if(oldPmInuse == null) {
                newPmInuse = pmDescriptors.newPmInuse();
                pmDescriptors.setPmInuse(newPmInuse);
                
                newPmInuse.setPmIdentifier(newPmIdentifier);
                newPmInuse.setPmVersion(newPmVersion);
            } else {
                newPmInuse = oldPmInuse;
                
                if(!Utils.strEquals(newPmIdentifier, newPmInuse.getPmIdentifier())) {
                    newPmInuse.setPmIdentifier(newPmIdentifier);
                    oldPmInuse = null;
                }
                if(!Utils.strEquals(newPmVersion, newPmInuse.getPmVersion())) {
                    newPmInuse.setPmVersion(newPmVersion);
                    oldPmInuse = null;
                }
            }
        }
        
        EjbJarRoot bean = masterPanel.getBean();
        if(bean != null && oldPmInuse != newPmInuse) {
            bean.firePropertyChange("pmInuse", oldPmInuse, newPmInuse); // NOI18N
            bean.validateField(EjbJarRoot.FIELD_PM_DESCRIPTORS);
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox jCbxPmInUse;
    private javax.swing.JLabel jLblPmInUse;
    // End of variables declaration//GEN-END:variables

    private void initUserComponents() {
        /* Add persistence manager descriptor table panel :
         * TableEntry list has five properties: id, version, config, class generator, and mapping factory.
         */
        ArrayList tableColumns = new ArrayList(5);
        tableColumns.add(new GenericTableModel.ValueEntry(null, PmDescriptor.PM_IDENTIFIER, 
            ejbjarBundle, "PmIdentifier", true, true));	// NOI18N - property name
        tableColumns.add(new GenericTableModel.ValueEntry(null, PmDescriptor.PM_VERSION,
            ejbjarBundle, "PmVersion", true, false));	// NOI18N - property name
        tableColumns.add(new GenericTableModel.ValueEntry(null, PmDescriptor.PM_CONFIG, 
            ejbjarBundle, "PmConfig", false, false));	// NOI18N - property name
        tableColumns.add(new GenericTableModel.ValueEntry(null, PmDescriptor.PM_CLASS_GENERATOR,
            ejbjarBundle, "PmClassGenerator", false, false));	// NOI18N - property name
        tableColumns.add(new GenericTableModel.ValueEntry(null, PmDescriptor.PM_MAPPING_FACTORY, 
            ejbjarBundle, "PmMappingFactory", false, false));	// NOI18N - property name

        pmDescriptorModel = new PmDescriptorTableModel(tableColumns);
        pmDescriptorPanel = new GenericTablePanel(pmDescriptorModel, 
            ejbjarBundle, "PmDescriptors",	// NOI18N - property name
            HelpContext.HELP_EJBJAR_PM_DESCRIPTOR_POPUP);

        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6,6,0,5);
        add(pmDescriptorPanel, gridBagConstraints);		
    }

    public void addListeners() {
        pmDescriptorModel.addTableModelListener(this);
        pmDescriptorModel.addTableModelListener(pmInUseModel);
        pmInUseModel.addListDataListener(this);
    }

    public void removeListeners() {
        pmInUseModel.removeListDataListener(this);
        pmDescriptorModel.removeTableModelListener(pmInUseModel);
        pmDescriptorModel.removeTableModelListener(this);
    }

    /** Initialization of all the fields in this panel from the bean that
     *  was passed in.
     */
    public void initFields(EjbJarRoot bean) {
        pmDescriptors = bean.getPmDescriptors();
        pmDescriptorPanel.setModel(pmDescriptors, bean.getAppServerVersion());

        pmInUseModel = new PmInUseCbxModel(pmDescriptorModel);
        jCbxPmInUse.setModel(pmInUseModel);

        Object selectedPmDescriptor = null;
        PmInuse pmInuse = pmDescriptors.getPmInuse();
        if(pmInuse != null) {
            selectedPmDescriptor = pmInUseModel.getElementByName(pmInuse.getPmIdentifier(), pmInuse.getPmVersion());
        }
        jCbxPmInUse.setSelectedItem(selectedPmDescriptor);
    }

    private static class PmInUseCbxModel extends DefaultComboBoxModel implements TableModelListener {
            
        private final GenericTableModel pmDescriptorTableModel;
        
        public PmInUseCbxModel(final GenericTableModel tableModel) {
            pmDescriptorTableModel = tableModel;

            // !PW I originally added the listener here, but there is no easy way to remove
            // it.  So now, the listener is added in the panel's addListeners() method and 
            // removed in the removedListeners() method.  This forces the assumption that the
            // table model in the constructor is the same one, which is error prone.  Thus
            // this requires further refactoring that is probably not worth effort right now.
            
            // Add existing data.
            List rows = pmDescriptorTableModel.getData();
            Iterator iter = rows.iterator();
            while(iter.hasNext()) {
                addElement(new PmDescriptorMapping((PmDescriptor) iter.next()));
            }
        }
        
        public Object getElementByName(String pmIdentifier, String pmVersion) {
            int len = getSize();
            for(int i = 0; i < len; i++) {
                PmDescriptorMapping mapping = (PmDescriptorMapping) getElementAt(i);
                if(mapping != null) {
                    PmDescriptor pmDescriptor = mapping.getPmDescriptor();
                    if(pmDescriptor != null && 
                            Utils.strEquals(pmDescriptor.getPmIdentifier(), pmIdentifier) && 
                            Utils.strEquals(pmDescriptor.getPmVersion(), pmVersion)) {
                        return mapping;
                    }
                }
            }
            return null;
        }

        public void tableChanged(TableModelEvent e) {
            if(TableModelEvent.UPDATE == e.getType()) {
                fireContentsChanged(this, e.getFirstRow(), e.getLastRow());
            } else if(TableModelEvent.DELETE == e.getType()) {
                int firstRow = Math.min(e.getFirstRow(), e.getLastRow());
                int lastRow = Math.max(e.getFirstRow(), e.getLastRow());
                for(int i = lastRow; i >= firstRow; i--) {
                    removeElementAt(i);
                }
            } else if(TableModelEvent.INSERT == e.getType()) {
                int firstRow = Math.min(e.getFirstRow(), e.getLastRow());
                int lastRow = Math.max(e.getFirstRow(), e.getLastRow());
                List rows = pmDescriptorTableModel.getData();
                for(int i = firstRow; i <= lastRow; i++) {
                    insertElementAt(new PmDescriptorMapping((PmDescriptor) rows.get(i)), i);
                }
            }
        }
    }
    
	private static class PmDescriptorTableModel extends GenericTableModel {
		public PmDescriptorTableModel(List tableColumns) {
			super(PmDescriptors.PM_DESCRIPTOR, pmDescriptorFactory, tableColumns);
		}
		
		public boolean alreadyExists(Object[] values) {
			boolean exists = false;
			
			List children = getChildren();
			for(Iterator iter = children.iterator(); iter.hasNext(); ) {
				PmDescriptor descriptor = (PmDescriptor) iter.next();
				if(match((String) values[0], descriptor.getPmIdentifier()) &&
				   match((String) values[1], descriptor.getPmVersion())) {
					   exists = true;
					   break;
				}
			}

			return exists;
		}
		
		private final boolean match(String a, String b) {
			boolean result = false;
			
			if(a == b) {
				result = true;
			} else if(a != null && b != null && a.equals(b)) {
				result = true;
			}
			
			return result;
		}

		public boolean alreadyExists(String keyPropertyValue) {
			// FIXME we can't actually support this API properly with the current
			// design so just have it fail.
			return false;
		}
	}    
    
    /** ----------------------------------------------------------------------- 
     *  Implementation of javax.swing.event.TableModelListener
     */
    public void tableChanged(TableModelEvent e) {
        EjbJarRoot bean = masterPanel.getBean();
        if(bean != null) {
            Object eventSource = e.getSource();
            if(eventSource == pmDescriptorModel) {
                // Force property change to be issued by the bean
                bean.firePropertyChange("pmDescriptors", null, pmDescriptors);
            }
        }
    }

    /** ----------------------------------------------------------------------- 
     *  Implementation of javax.swing.event.ListDataListener
     */
    public void intervalRemoved(ListDataEvent e) {
        // Default behavior is acceptable.
    }

    public void intervalAdded(ListDataEvent e) {
        Object eventSource = e.getSource();
        if(eventSource == pmInUseModel) {
            Object selectedItem = jCbxPmInUse.getSelectedItem();
            if(selectedItem == null && pmInUseModel.getSize() > 0) {
                jCbxPmInUse.setSelectedIndex(0);
            }
        }
    }

    public void contentsChanged(ListDataEvent e) {
        Object eventSource = e.getSource();
        if(eventSource == pmInUseModel) {
            // In case the id or version of the current selected item changed.
            updatePmInuse((PmDescriptorMapping) jCbxPmInUse.getSelectedItem());
        }
    }
    
    // New for migration to sun DD API model.  Factory instance to pass to generic table model
    // to allow it to create messageDestination beans.
    static GenericTableModel.ParentPropertyFactory pmDescriptorFactory =
        new GenericTableModel.ParentPropertyFactory() {
            public CommonDDBean newParentProperty(ASDDVersion asVersion) {
                return StorageBeanFactory.getStorageBeanFactory(asVersion).createPmDescriptor();
            }
        };

}
