/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.sun.util;

import java.io.IOException;
import junit.framework.*;
import com.sun.appserv.management.client.ConnectionSource;
import com.sun.appserv.management.client.AppserverConnectionSource;
import com.sun.appserv.management.DomainRoot;
import org.netbeans.modules.j2ee.sun.util.AppserverConnectionFactory;

/**
 *
 * 
 */
public class AppserverConnectionFactoryTest extends TestCase {
    
    private static final String HOST = "localhost";
    private static final int PORT = 4848;
    private static final String USER_NAME = "admin";
    private static final String PASSWORD = "adminadmin";
    
    
    public AppserverConnectionFactoryTest(java.lang.String testName) {
        super(testName);
    }
    
    public void testGetHTTPAppserverConnection() {
        AppserverConnectionSource conn = 
            AppserverConnectionFactory.getHTTPAppserverConnectionSource(HOST, 
                PORT, USER_NAME, PASSWORD, null);
        assertNotNull(conn);
        try {
            conn.getDomainRoot();
        } catch(IOException e) {
            fail("Error connecting to the DAS!!!");
            e.printStackTrace();
        }
    }
    
    public void testIsAppserverConnectionSecurityEnabled() {
        try {
            System.out.println("Is Security Enabled? " + 
            AppserverConnectionFactory.isAppserverConnectionSecurityEnabled(
                    AppserverConnectionFactory.getHTTPAppserverConnectionSource(
                        HOST, PORT, USER_NAME, PASSWORD, null)));
        } catch(IOException e) {
            e.printStackTrace();
        }
    }
    
    
    public void testGetAppserverConnection() {
        try {
            AppserverConnectionSource conn = 
                AppserverConnectionFactory.getAppserverConnection(HOST, PORT, 
                    USER_NAME, PASSWORD, null, false);
            System.out.println(conn.getDomainRoot().getAppserverDomainName());
            System.out.println(conn.getJMXConnector(false).getConnectionId());
            AppserverConnectionSource conn2 = 
                AppserverConnectionFactory.getAppserverConnection(HOST, PORT, 
                    USER_NAME, PASSWORD, null, true);
            AppserverConnectionSource conn3 = 
                AppserverConnectionFactory.getAppserverConnection(HOST, PORT, 
                    USER_NAME, PASSWORD, null, false);
        } catch(Exception e) {
            e.printStackTrace();
        }
    }
    
    
    public static Test suite() {
        TestSuite suite = new TestSuite(AppserverConnectionFactoryTest.class);
        return suite;
    }
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
}