/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.sun.util;

import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

import javax.swing.SwingUtilities;


/**
 *
 */
public class GUIUtils {
    
    /** 
     * Cannot instantiate.
     */
    private GUIUtils() {
    }
    
    
    /**
     *
     *
     */
    public static void showError(final String message){
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                NotifyDescriptor d = 
                    new NotifyDescriptor.Message(message, 
                            NotifyDescriptor.ERROR_MESSAGE);
                DialogDisplayer.getDefault().notify(d);
            }
        });

    }
    
    /**
     *
     *
     */
    public static void showInformation(final String message){
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                NotifyDescriptor d = 
                    new NotifyDescriptor.Message(message,
                            NotifyDescriptor.INFORMATION_MESSAGE);
                DialogDisplayer.getDefault().notify(d);
            }
        });
        
    }
    
    
    /**
     *
     *
     */
    public static Object showWarning(final String message){
        NotifyDescriptor d = 
            new NotifyDescriptor.Confirmation(message, 
                NotifyDescriptor.OK_CANCEL_OPTION, 
                    NotifyDescriptor.WARNING_MESSAGE);
        return DialogDisplayer.getDefault().notify(d);
    }

}
