/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.sun.util;

import org.openide.explorer.propertysheet.editors.EnhancedPropertyEditor;

import org.netbeans.modules.j2ee.sun.ide.editors.BooleanEditor;
import org.netbeans.modules.j2ee.sun.ide.editors.DataSourceTypeEditor;
import org.netbeans.modules.j2ee.sun.ide.editors.IsolationLevelEditor;
import org.netbeans.modules.j2ee.sun.ide.editors.ValidationMethodEditor;
/**
 *
 */
public class EnhancedPropertyEditorFactory {
    
    private static EnhancedPropertyEditorFactory factory;
    
    
    /** 
     * Creates a new instance of EnhancedPropertyEditorFactory 
     */
    private EnhancedPropertyEditorFactory() {
    }
    
    
    /**
     *
     *
     */
    public static EnhancedPropertyEditorFactory getInstance() {
        if(factory == null) {
            factory = new EnhancedPropertyEditorFactory();
        }
        return factory;
    }
    
    
    /**
     * Returns the appropriate editor given the type of the value.
     *
     * @param valueType The type of the value to be displayed in a 
     *        Property Sheet.
     * @return An EnhancedPropertyEditor for the value type specified.
     */
    public EnhancedPropertyEditor getEnhancedPropertyEditor(
            final Object value, final String customType) {
        if(customType.equals(PropertyConstants.DATASOURCE_TYPE_FIELD))
            return new DataSourceTypeEditor();
        else if(customType.equals(PropertyConstants.ISOLATION_LEVEL_FIELD))
            return new IsolationLevelEditor(true);
        else if(customType.equals(PropertyConstants.VALIDATION_METHOD_FIELD))
            return new ValidationMethodEditor();
        else if(value instanceof Boolean) {
            return new BooleanEditor();
        } else {
            return new BooleanEditor();
        }

    }
    
}
