/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * UtilMEJB.java
 *
 * Created on August 13, 2003, 12:31 PM
 */

package org.netbeans.modules.j2ee.sun.share.management;



import javax.management.MBeanServerConnection;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.InstanceNotFoundException;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import java.util.Set;
import java.util.Arrays;
import java.util.HashSet;
import java.rmi.RemoteException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanInfo;
import javax.management.ObjectName;

import org.netbeans.modules.j2ee.sun.ide.j2ee.mbmapping.Constants;

/**
 *
 * @author  nityad
 */
public class UtilMEJB implements Constants{

    private MBeanServerConnection conn = null;
        
    
    /** Creates a new instance of UtilMEJB */
    
    
    public UtilMEJB(String host, int port, String username, String password ,boolean secure)  throws RemoteException{


        ClassLoader origClassLoader=Thread.currentThread().getContextClassLoader();
        try{
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        conn = org.netbeans.modules.j2ee.sun.bridge.AppServerBridge.getJMXConnector( host,  port,  username,  password,secure);

        }catch(Exception ex){
            throw new RemoteException(ex.getMessage(), ex.getCause());
        }
        
        finally{
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }

    
    protected MBeanServerConnection getConnection(){
        return this.conn;
    }
    
    protected AttributeList updateGetAttributes(ObjectName objName, String[] attributes){
        AttributeList attList = null;
        try{
            String isResource = objName.getKeyProperty("type"); //NOI18N
            Set configMods = new HashSet(Arrays.asList(CONFIG_MODULE));
            if((isResource != null) && (! configMods.contains(isResource))){ 
                attList = this.conn.getAttributes(objName, attributes);
            }
        }catch(Exception ex){
            //Empty list is returned.
        }
        return attList;
    }
    
    protected Object updateGetAttribute(ObjectName objName, String attribute){
        Object attr = null;
        try{
            String isResource = objName.getKeyProperty("type"); //NOI18N
            Set configMods = new HashSet(Arrays.asList(CONFIG_MODULE));
            if((isResource != null) && (! configMods.contains(isResource))){
                attr = this.conn.getAttribute(objName, attribute);
            }
            String type = objName.getKeyProperty("j2eeType"); //NOI18N
            if(type.equals("J2EEServer")) { //NOI18N
                attr = this.conn.getAttribute(objName, attribute);
            }   
        }catch(Exception ex){
            //Null value is returned
        }
        return attr;
    }
    
    protected Object updateInvoke(ObjectName objName, String operationName, Object[] params, String[] signature) throws RemoteException{
        //If condition is satisfied only for createResource
        if(objName.toString().equals(MAP_RESOURCES))
            return invokeServerForResource(objName, operationName, params, signature);
        else
            return invokeServer(objName, operationName, params, signature);
    }
        
    private Object invokeServer(ObjectName objName, String operationName, Object[] params, String[] signature)  throws RemoteException{
        Object retVal = null;
        try{
            retVal = this.conn.invoke(objName, operationName, params, signature);
        }catch(Exception ex){
//            if (!objName.toString().startsWith("ias:type=domain,category=config")){
//                System.out.println(" Error in invokeServer " + ex.getMessage());
//            }
            throw new RemoteException(ex.getMessage(), ex.getCause());

        }
        return retVal;
    }
    
    private Object invokeServerForResource(ObjectName objName, String operationName, Object[] params, String[] signature) throws RemoteException{
        Object retVal = null;
        try{
            if(operationName.equals("setProperty")){ //NOI18N
                this.conn.invoke(objName, operationName, params, signature);
            }else{
                retVal = this.conn.invoke(objName, operationName, params, signature);
            }
        }catch(Exception ex){
            throw new RemoteException(ex.getMessage(),ex.getCause());
        }
        return retVal;
    }
        
    protected MBeanInfo updateMBeanInfo(ObjectName objName){
        MBeanInfo bnInfo = null;
        try{
            String isResource = objName.getKeyProperty("type"); //NOI18N
            Set configMods = new HashSet(Arrays.asList(CONFIG_MODULE));
            if((isResource != null) && (! configMods.contains(isResource))){
                bnInfo = this.conn.getMBeanInfo(objName);
            }
        }catch(Exception ex){
            //Property sheet is not created
        }
        return bnInfo;
    }
    
    protected void updateSetAttribute(ObjectName objName, Attribute attribute) throws RemoteException, InstanceNotFoundException, AttributeNotFoundException,
            InvalidAttributeValueException, MBeanException, ReflectionException {
        try{
            String isResource = objName.getKeyProperty("type"); //NOI18N
            Set configMods = new HashSet(Arrays.asList(CONFIG_MODULE));
            if((isResource != null) && (! configMods.contains(isResource))){    
                this.conn.setAttribute(objName, attribute);
            }
        }catch(java.io.IOException ex){
            throw new RemoteException(ex.getLocalizedMessage(), ex.getCause());
        }
    }    
    
}


