/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.sun.ide.runtime.nodes;

import java.util.List;
import java.util.Arrays;
import javax.management.ObjectName;
import javax.swing.Action;


import org.netbeans.modules.j2ee.sun.util.NodeTypes;
import com.sun.appserv.management.base.Util;
import org.netbeans.modules.j2ee.sun.ide.controllers.ControllerUtil;
import org.netbeans.modules.j2ee.sun.ide.controllers.WebModuleController;
import org.netbeans.modules.j2ee.sun.ide.runtime.actions.EnableDisableAction;
import org.netbeans.modules.j2ee.sun.ide.runtime.actions.UndeployAction;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;




/**
 */
public class WebModuleNode extends AppserverMgmtApplicationsNode {
        
    private static String NODE_TYPE = NodeTypes.WEB_MODULE;
        
    /**
     *
     *
     */
    public WebModuleNode(WebModuleController controller) {
        super(getChildNodes(controller), controller, NODE_TYPE, false);
        setDisplayName(controller.getDisplayName());
    }

    
    /**
     *
     *
     */
    public WebModuleNode(final WebModuleController controller,
            final boolean isEmbedded) {
        super(getChildNodes(controller), controller, NODE_TYPE, isEmbedded);
        setDisplayName(controller.getDisplayName());
    }
    
    public WebModuleNode(final String name) {
        super(Children.LEAF, null, NODE_TYPE, true);
        setDisplayName(name);
    }
    
    /**
     *
     */
    static Children getChildNodes(WebModuleController controller) {
        return createWebModuleNodeChildren(controller);
    }
    /**
     * Return the actions associated with the menu drop down seen when
     * a user right-clicks on an Applications node in the plugin.
     *
     * @param boolean true/false
     * @return An array of Action objects.
     */
    public Action[] getActions(boolean flag) {
        if(!isEmbedded) {
            return new SystemAction[] {
                SystemAction.get(UndeployAction.class),
                SystemAction.get(EnableDisableAction.class),
                SystemAction.get(PropertiesAction.class)
            };
        } else {
            return new SystemAction[] {
                SystemAction.get(PropertiesAction.class)
            };
        }
    }    
    
    /**
     *
     */
    static Children createWebModuleNodeChildren(WebModuleController controller) {
        
        Children children = new Children.Array();
        java.util.Vector nodes = new java.util.Vector();
        
        //create all embedded servlets
        if(controller.getJ2EEObject() != null){
            String [] servlets = controller.getServlets();
            if(servlets != null || servlets.length > 0) {
                for(int i = 0; i < servlets.length; i++) {
                    nodes.add(new ServletNode(controller, servlets[i]));
                }
            }
        }else{
            ObjectName[] subComponents = ControllerUtil.getSubComponentsFromConfig(controller.getName(), controller.getMBeanServerConnection());
            for(int i=0; i<subComponents.length; i++){
                ObjectName oname = subComponents[i];
                String name = Util.getName(oname);
                nodes.add(new ServletNode(name));
            };
        }
        
        Node[] arrayToAdd = new Node[nodes.size()];
        children.add((Node[])nodes.toArray(arrayToAdd));
        return children;  
    }

    protected List getPropertiesToIgnore() {
        //Only for web module, these properties are the only ones displayed.
        return Arrays.asList(NodeTypes.WEB_MODULE_NODE);        
    }
}
