/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.sun.ide.runtime.nodes;

import org.netbeans.modules.j2ee.sun.bridge.apis.AppserverMgmtLeafNode;

import org.netbeans.modules.j2ee.sun.util.NodeTypes;
import org.netbeans.modules.j2ee.sun.ide.controllers.EJBModuleController;

/**
 */
public class EntityEjbNode extends AppserverMgmtLeafNode {
    
    private static final String NODE_TYPE = NodeTypes.ENTITY_BEAN;
    private EJBModuleController controller;
    private String ejbName;
    

    
    /**
     * Constructor for instantiating a new EntityEjbNode. 
     *
     * @param controller The name of the EjbModuleController to which this 
     *        ejb belongs.
     * @param ejbName The name of the ejb to which this node refers.
     */
    public EntityEjbNode(EJBModuleController controller, String ejbName) {
        super(NODE_TYPE);
        this.ejbName = ejbName;
        this.controller = controller;
        setDisplayName(ejbName);
    }
    
    public EntityEjbNode(String name) {
        super(NODE_TYPE);
        this.ejbName = name;
        setDisplayName(name);
    }
    
    /**
     * Return the SheetProperties to be displayed for this EJB.
     *
     * @return A java.util.Map containing all PM properties.
     */
    protected java.util.Map getSheetProperties() {
        return controller.getEntityEJBProperties(ejbName,
                getPropertiesToIgnore());
    }
    
    
    /**
     * Sets the property as an attribute to the underlying AMX mbeans. It 
     * usually will delegate to the controller object which is responsible for
     * finding the correct AMX mbean objectname in order to execute a 
     * JMX setAttribute.
     *
     * @param attrName The name of the property to be set.
     * @param value The value retrieved from the property sheet to be set in the
     *        backend.
     * @returns the updated Attribute accessed from the Sheet.
     */
    public javax.management.Attribute setSheetProperty(String attrName, Object value) {
        return controller.setEntityEJBProperties(getName(), attrName, value);
    }
    
}
