package org.netbeans.modules.j2ee.sun.ide.controllers;
/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
import java.util.Iterator;
import java.util.Map;
import java.util.List;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.j2ee.AppClientModule;
import com.sun.appserv.management.j2ee.EJBModule;
import com.sun.appserv.management.j2ee.J2EEApplication;
import com.sun.appserv.management.j2ee.J2EEServer;
import com.sun.appserv.management.j2ee.ResourceAdapterModule;
import com.sun.appserv.management.j2ee.WebModule;
import com.sun.appserv.management.client.AppserverConnectionSource;
import com.sun.appserv.management.config.AppClientModuleConfig;
import com.sun.appserv.management.config.EJBModuleConfig;
import com.sun.appserv.management.config.J2EEApplicationConfig;
import com.sun.appserv.management.config.RARModuleConfig;
import com.sun.appserv.management.config.WebModuleConfig;
import com.sun.appserv.management.j2ee.J2EEDeployedObject;
import java.util.Arrays;

import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.modules.j2ee.sun.bridge.apis.AppserverMgmtControllerBase;
import org.netbeans.modules.j2ee.sun.bridge.apis.Controller;

/**
 * Used as a conduit between the Netbeans API's and the AMX MBean API
 * data model. This API contains convienent methods for retrieving
 * components allowing the netbeans module heirarchy remain agnostic to the
 * underlying data model. This controller is used to navigate through deployed
 * applications and web, ejb, connector, and app client modules.
 */
public class J2EEServerMgmtController 
        extends AppserverMgmtControllerBase implements Controller {
    
    private J2EEServer j2eeServer;

    /**
     * Create an instance of J2EEServerMgmtController used in the interaction
     * with AMX API for Sun Java System Application Server. 
     * 
     * @param server The AMX J2EEServer object representing a particular server.
     */
    public J2EEServerMgmtController(final J2EEServer server, 
            final DeploymentManager dplmtMgr, 
            final AppserverConnectionSource connection) {
        super(server, dplmtMgr, connection);
        this.j2eeServer = server;
    }

    
    /**
     * Returns all the properties of this server instance.
     *
     * @return All the properties of this server instance as a java.util.Map.
     */
    public Map getProperties(List propsToIgnore) { 
        return new java.util.HashMap() {};
    }
    
    
    /**
     * Sets the properties.
     *
     * @param attrname The name of the attribute.
     * @param value The value of the attribute to set. 
     *
     * @return updated Attribute
     */
    public javax.management.Attribute setProperty(final String attrName, final Object value) { 
        
        testIfServerInDebug();
        
        return ControllerUtil.setAttributeValue(j2eeServer, attrName, value, 
            getMBeanServerConnection());
    }
    
    
    /**
     *
     *
     */
    public J2EEApplicationMgmtController[] getApplications() {
        
        testIfServerInDebug();
        
        Map apps = j2eeServer.getContaineeMap(J2EEApplication.J2EE_TYPE);
        Map appsMap = getJ2EEAppsAsMap(J2EEApplication.J2EE_TYPE);
        Map configPeerApps = j2eeServer.getConfigPeer().getContainer().getContaineeMap(J2EEApplicationConfig.J2EE_TYPE);
        configPeerApps = ControllerUtil.stripOutSystemApps(configPeerApps); 
        
        java.util.Vector controllers = new java.util.Vector();
        for(Iterator configPeerItr = configPeerApps.values().iterator(); configPeerItr.hasNext(); ) {
            J2EEApplicationConfig appConfig = (J2EEApplicationConfig)configPeerItr.next(); 
            J2EEApplication appMod = null;
            if(appsMap.containsKey(appConfig.getName())){
                appMod = (J2EEApplication)appsMap.get(appConfig.getName());
            }
            controllers.add(new J2EEApplicationMgmtController(
                appMod, appConfig, getDeploymentManager(), 
                    appMgmtConnection)); 
        }
        
        J2EEApplicationMgmtController[] result = 
            new J2EEApplicationMgmtController[controllers.size()];
        return (J2EEApplicationMgmtController[]) controllers.toArray(result);
    }
    
    
    /**
     *
     *
     */
    public EJBModuleController[] getEJBModules() {
        
        testIfServerInDebug();
        
        Map apps = j2eeServer.getContaineeMap(EJBModule.J2EE_TYPE);
        Map appsMap = getJ2EEAppsAsMap(EJBModule.J2EE_TYPE);
        Map configPeerApps = j2eeServer.getConfigPeer().getContainer().getContaineeMap(EJBModuleConfig.J2EE_TYPE);
        configPeerApps = ControllerUtil.stripOutSystemApps(configPeerApps); 
        
        java.util.Vector controllers = new java.util.Vector();
        for(Iterator configPeerItr = configPeerApps.values().iterator(); configPeerItr.hasNext(); ) {
            EJBModuleConfig ejbConfig = (EJBModuleConfig)configPeerItr.next(); 
            EJBModule ejbMod = null;
            if(appsMap.containsKey(ejbConfig.getName())){
                ejbMod = (EJBModule)appsMap.get(ejbConfig.getName());
            }
            controllers.add(new EJBModuleController(
                ejbMod, ejbConfig, getDeploymentManager(), 
                    appMgmtConnection));            
        }
        
        EJBModuleController[] result = 
            new EJBModuleController[controllers.size()];
        return (EJBModuleController[]) controllers.toArray(result);
    }
    
    
    /**
     *
     *
     */
    public ConnectorModuleController[] getConnectorModules() {
        
        testIfServerInDebug();
        Map j2eeApps = j2eeServer.getContaineeMap(ResourceAdapterModule.J2EE_TYPE);
        Map appsMap = getJ2EEAppsAsMap(ResourceAdapterModule.J2EE_TYPE);
        Map configPeerApps = j2eeServer.getConfigPeer().getContainer().getContaineeMap(RARModuleConfig.J2EE_TYPE);
        configPeerApps = ControllerUtil.stripOutSystemApps(configPeerApps); 
        java.util.Vector controllers = new java.util.Vector();
        for(Iterator configPeerItr = configPeerApps.values().iterator(); configPeerItr.hasNext(); ) {
            RARModuleConfig rarConfig = (RARModuleConfig)configPeerItr.next(); 
            ResourceAdapterModule rarMod = null;
            if(appsMap.containsKey(rarConfig.getName())){
                rarMod = (ResourceAdapterModule)appsMap.get(rarConfig.getName());
            }
        
            if(! Arrays.asList(ControllerUtil.RES_ADAPTOR_KEYS).contains(rarConfig.getName())){
                controllers.add(new ConnectorModuleController(
                        rarMod, rarConfig, getDeploymentManager(), appMgmtConnection));
            }           
        }
        ConnectorModuleController[] result = 
            new ConnectorModuleController[controllers.size()];
        return (ConnectorModuleController[]) controllers.toArray(result);
    }

    
    /**
     *
     *
     */
    public WebModuleController[] getWebModules() {
        
        testIfServerInDebug();
        
        Map apps = j2eeServer.getContaineeMap(WebModule.J2EE_TYPE);
        Map appsMap = getJ2EEAppsAsMap(WebModule.J2EE_TYPE);
        Map configPeerApps = j2eeServer.getConfigPeer().getContainer().getContaineeMap(WebModuleConfig.J2EE_TYPE);
        configPeerApps = ControllerUtil.stripOutSystemApps(configPeerApps); 
        
        java.util.Vector controllers = new java.util.Vector();
        for(Iterator configPeerItr = configPeerApps.values().iterator(); configPeerItr.hasNext(); ) {
            WebModuleConfig webConfig = (WebModuleConfig)configPeerItr.next(); 
            WebModule webMod = null;
            if(appsMap.containsKey(webConfig.getName())){
                webMod = (WebModule)appsMap.get(webConfig.getName());
            }
            controllers.add(new WebModuleController(
                webMod, webConfig, getDeploymentManager(), 
                    appMgmtConnection));            
        }
       
        WebModuleController[] result = 
            new WebModuleController[controllers.size()];
        return (WebModuleController[]) controllers.toArray(result);
    }

    /**
     * Return the web module name of a standlaone or embeded webmodule
     * from the context root
     * @param String reprsenting the Context Root of the web module
     * @return String giving the web module name. Can be null
     */
    public String getWebModuleName(String contextRoot) {
        
        testIfServerInDebug();
        String modName = null;
        Map webApps = j2eeServer.getConfigPeer().getContainer().getContaineeMap(WebModuleConfig.J2EE_TYPE);
        webApps = ControllerUtil.stripOutSystemApps(webApps); 
        
        for(Iterator webAppsItr = webApps.values().iterator(); webAppsItr.hasNext(); ) {
            WebModuleConfig webConfig = (WebModuleConfig)webAppsItr.next(); 
            String cRoot = webConfig.getContextRoot();
            if(cRoot.equals(contextRoot)){
                modName = webConfig.getName();
                break;
            }    
        }  
        
        if(modName == null){
            Map j2eeApps = ControllerUtil.stripOutSystemApps(
                j2eeServer.getContaineeMap(J2EEApplication.J2EE_TYPE));
            for(Iterator itr = j2eeApps.values().iterator(); itr.hasNext(); ) {
                J2EEApplication j2eeApp = (J2EEApplication)itr.next();
                
                Map compWebs = ControllerUtil.stripOutSystemApps(
                        j2eeApp.getContaineeMap(WebModule.J2EE_TYPE));                
                for(Iterator webItr = compWebs.values().iterator(); webItr.hasNext(); ) {
                    WebModule webApp = (WebModule)webItr.next();
                    String cRoot = webApp.getPath();                   
                    if(cRoot.equals(contextRoot)){
                        String appName = j2eeApp.getName();
                        String webName = webApp.getName();
                        if(webName.indexOf("//server") != -1)  //NOI18N
                            webName = webName.substring(8, webName.length());
                        webName = webName + "_war"; //NOI18N
                        modName = appName + webName;
                        break;
                    }
                } //for
                
            }
        } //modName null
        return modName;
    }
    
    /**
     *
     */
    public AppClientModuleController[] getAppClientModules() {
        
        testIfServerInDebug();
        
        String configPeerType = ControllerUtil.getConfigPeerAMXType(AppClientModule.J2EE_TYPE);
        Map configPeerApps = j2eeServer.getConfigPeer().getContainer().getContaineeMap(configPeerType);
        
        Map apps = j2eeServer.getContaineeMap(AppClientModule.J2EE_TYPE);
        Map appsMap = getJ2EEAppsAsMap(AppClientModule.J2EE_TYPE);
        
        java.util.Vector controllers = new java.util.Vector();
        for(Iterator configPeerItr = configPeerApps.values().iterator(); configPeerItr.hasNext(); ) {
            AppClientModuleConfig appClientConfig = (AppClientModuleConfig)configPeerItr.next(); 
            AppClientModule appClientMod = null;
            if(appsMap.containsKey(appClientConfig.getName())){
                appClientMod = (AppClientModule)appsMap.get(appClientConfig.getName());
            }
            controllers.add(new AppClientModuleController(
                appClientMod, appClientConfig, getDeploymentManager(), 
                    appMgmtConnection));            
        }
        
        AppClientModuleController[] result = 
            new AppClientModuleController[controllers.size()];
        return (AppClientModuleController[]) controllers.toArray(result);
    }
    
    private Map getJ2EEAppsAsMap(String type){
        Map apps = ControllerUtil.stripOutSystemApps(j2eeServer.getContaineeMap(type));
        Map j2eePeerMap = new java.util.HashMap();
        for(Iterator itr = apps.values().iterator(); itr.hasNext(); ) {
            J2EEDeployedObject j2eeMod = (J2EEDeployedObject)itr.next();
            if(j2eeMod.getConfigPeer() != null)
                j2eePeerMap.put(j2eeMod.getConfigPeer().getName(), j2eeMod);
        }
        return j2eePeerMap;
    }
    
    public String getServerName(){
        return j2eeServer.getserverVersion();
    }
}
