package org.netbeans.modules.j2ee.sun.ide.controllers;
/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
import com.sun.appserv.management.j2ee.J2EEDeployedObject;
import java.util.Iterator;
import java.util.List;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.config.Enabled;
import com.sun.appserv.management.client.AppserverConnectionSource;
import com.sun.appserv.management.config.DeployedItemRefConfig;
import com.sun.appserv.management.config.J2EEApplicationConfig;
import com.sun.appserv.management.j2ee.J2EEApplication;
import com.sun.appserv.management.j2ee.EJBModule;
import com.sun.appserv.management.j2ee.WebModule;
import com.sun.appserv.management.j2ee.AppClientModule;
import com.sun.appserv.management.j2ee.ResourceAdapterModule;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.modules.j2ee.sun.bridge.apis.AppserverMgmtControllerBase;

import org.netbeans.modules.j2ee.sun.util.NodeTypes;

/**
 * Used as a conduit between the Netbeans API's and the AMX MBean API
 * data model. This API contains convenient methods for retrieving
 * components allowing the netbeans module heirarchy remain agnostic to the
 * underlying data model. 
 * 
 * This controller is used to navigate through deployed applications 
 * subcomponents such as web, ejb, connector, and app client modules.
 */
public class J2EEApplicationMgmtController extends AppserverMgmtControllerBase 
        implements DeployedItemsController, EnablerController {
    
    private J2EEApplication application;
    private J2EEApplicationConfig appConfig;
       
    /**
     * Create an instance of J2EEServerMgmtController used in the interaction
     * with AMX API for Sun Java System Application Server. 
     * 
     * @param server The AMX J2EEServer object representing a particular server.
     */
    public J2EEApplicationMgmtController(final J2EEApplication application, 
            final DeploymentManager dplmtMgr,
            final AppserverConnectionSource connection) {
        super(application, dplmtMgr, connection);
        this.application = application;
    }

     public J2EEApplicationMgmtController(final J2EEApplication application, 
            final J2EEApplicationConfig appConfig, 
            final DeploymentManager dplmtMgr,
            final AppserverConnectionSource connection) {
        super(appConfig, dplmtMgr, connection);
        this.application = application;
        this.appConfig = appConfig;
    }
    /**
     * Returns the properties of the application given the name.
     * 
     * @param appName The name of the application.
     * @return All the application properties.
     */
    public java.util.Map getProperties(List propsToIgnore) {  
        return getJ2EEAndConfigProperties(NodeTypes.ENTERPRISE_APPLICATION, 
            this.application, this.appConfig, propsToIgnore); 
    }
    
    
    /**
     * Sets the properties.
     *
     * @param attrname The name of the attribute.
     * @param value The value of the attribute to set. 
     *
     * @return updated Attribute
     */
    public javax.management.Attribute setProperty(final String attrName, final Object value) { 
        
        testIfServerInDebug();
        
        return ControllerUtil.setAttributeValue(application, appConfig, attrName, value, 
            getMBeanServerConnection());
    }
    
    /**
     *
     *
     */
    public EJBModuleController[] getEJBModules() {
        
        testIfServerInDebug();
        
        java.util.Map apps = application.getContaineeMap(EJBModule.J2EE_TYPE);
        java.util.Vector controllers = new java.util.Vector();
        for(Iterator itr = apps.values().iterator(); itr.hasNext(); ) {
            controllers.add(new EJBModuleController(
                (EJBModule)itr.next(), getDeploymentManager(),
                    appMgmtConnection));
        }
        EJBModuleController[] result = 
            new EJBModuleController[controllers.size()];
        return (EJBModuleController[]) controllers.toArray(result);
    }

    
    /**
     *
     *
     */
    public AppClientModuleController[] getAppClientModules() {
        
        testIfServerInDebug();
        
        java.util.Map apps = application.getContaineeMap(AppClientModule.J2EE_TYPE);
        java.util.Vector controllers = new java.util.Vector();
        for(Iterator itr = apps.values().iterator(); itr.hasNext(); ) {
            controllers.add(new AppClientModuleController(
                (AppClientModule)itr.next(), getDeploymentManager(), 
                    appMgmtConnection));
        }
        AppClientModuleController[] result = 
            new AppClientModuleController[controllers.size()];
        return (AppClientModuleController[]) controllers.toArray(result);
    }

    
    /**
     *
     *
     */
    public ConnectorModuleController[] getConnectorModules() {
        
        testIfServerInDebug();
        
        String resJ2EETypeProp = 
            Util.makeJ2EETypeProp(ResourceAdapterModule.J2EE_TYPE);
        String appProperty = 
            JMXUtil.makeProp(J2EEApplication.J2EE_TYPE, getName());
        String props = Util.concatenateProps(resJ2EETypeProp, appProperty);
        java.util.Set embeddedRars = getQueryMgr().queryPropsSet(props);
        java.util.Vector resAdaptorModules = new java.util.Vector();
        for(Iterator itr = embeddedRars.iterator(); itr.hasNext(); ) {
            resAdaptorModules.add(new ConnectorModuleController(
                    (ResourceAdapterModule)itr.next(), getDeploymentManager(),
                        appMgmtConnection));
        }
        ConnectorModuleController[] result = 
            new ConnectorModuleController[resAdaptorModules.size()];
        return (ConnectorModuleController[]) resAdaptorModules.toArray(result);
    }
    
    
    /**
     *
     *
     */
    public WebModuleController[] getWebModules() {
        
        testIfServerInDebug();
        java.util.Map apps = ControllerUtil.stripOutSystemApps(
            application.getContaineeMap(WebModule.J2EE_TYPE));
        
        java.util.Vector controllers = new java.util.Vector();
        for(Iterator itr = apps.values().iterator(); itr.hasNext(); ) {
            controllers.add(new WebModuleController(
                (WebModule)itr.next(), getDeploymentManager(),
                    appMgmtConnection));
        }
        WebModuleController[] result = 
            new WebModuleController[controllers.size()];
        return (WebModuleController[]) controllers.toArray(result);
    }
    
    /**
     * Returns all the names of the web modules embedded in the specified
     * deployed application.
     *
     * @return An array of modules embedded in this application.
     */
    public String[] getEmbeddedModulesByType(String nodeType) {
        
        testIfServerInDebug();
        
        return ControllerUtil.getComponentNamesFromMap(
            application.getContaineeMap(
                NodeTypes.getAMXJ2EETypeByNodeType(nodeType)));
    }
    
    
    /**
     *
     */
    public String[] getEjbsByType(String nodeType, String ejbModuleName, 
            String ejbName) {
        
        testIfServerInDebug();
        
         return ControllerUtil.getComponentNamesFromMap(
            application.getContaineeMap(
                NodeTypes.getAMXJ2EETypeByNodeType(nodeType)));
    }
    
    
    /**
     * Returns the EJBModule object by ejb module name.
     *
     * @param ejbModuleName The name of the ejbmodule.
     * @return The EJBModule object corresponding to the name given.
     */
    public EJBModule getEJBModuleByName(String ejbModuleName) {
        
        testIfServerInDebug();
        
        java.util.Map modules = application.getContaineeMap(EJBModule.J2EE_TYPE);
        return (EJBModule) modules.get(ejbModuleName);
    }
    
    
    /**
     *
     *
     *
     */
    public boolean isEnabled() {
        testIfServerInDebug();
        boolean configEnabled = ((Enabled)appConfig).getEnabled();
        return ControllerUtil.calculateIsEnabled(appConfig, configEnabled);
    }
    
    
    /**
     *
     *
     *
     */
    public void setEnabled(boolean enabled) {
        testIfServerInDebug();
        DeployedItemRefConfig config = ControllerUtil.getDeployedItemRefConfig(appConfig);
        if(config != null)
            config.setEnabled(enabled);
    }

    public J2EEDeployedObject getJ2EEObject() {
        return application;
    }
    
}



