/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.sun.ide.controllers;

import java.util.List;
import com.sun.appserv.management.client.AppserverConnectionSource;
import com.sun.appserv.management.config.Enabled;
import com.sun.appserv.management.j2ee.J2EEDeployedObject;
import com.sun.appserv.management.j2ee.ResourceAdapterModule;
import com.sun.appserv.management.j2ee.ResourceAdapter;
import com.sun.appserv.management.config.RARModuleConfig;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.modules.j2ee.sun.bridge.apis.AppserverMgmtControllerBase;

import org.netbeans.modules.j2ee.sun.util.NodeTypes;


/**
 * Used as a conduit between the Netbeans API's and the AMX MBean API
 * data model. This API contains convenient methods for retrieving
 * components allowing the netbeans module heirarchy remain agnostic to the
 * underlying data model. 
 * 
 * This controller is used to navigate through deployed EJB modules.
 */
public class ConnectorModuleController extends AppserverMgmtControllerBase 
        implements DeployedItemsController, EnablerController {
    
    private ResourceAdapterModule connectorModule;
    private RARModuleConfig connectorConfig;
    
    /**
     * Create an instance of J2EEServerMgmtController used in the interaction
     * with AMX API for Sun Java System Application Server. 
     * 
     * @param server The AMX J2EEServer object representing a particular server.
     */
    public ConnectorModuleController(ResourceAdapterModule connectorModule, 
            AppserverConnectionSource connection) {
        super(connectorModule, connection);
        this.connectorModule = connectorModule;
    }
    
    
    /**
     * Create an instance of J2EEServerMgmtController used in the interaction
     * with AMX API for Sun Java System Application Server. 
     * 
     * @param server The AMX J2EEServer object representing a particular server.
     */
    public ConnectorModuleController(
            final ResourceAdapterModule connectorModule, 
            final DeploymentManager dplmtMgr,
            final AppserverConnectionSource connection) {
        super(connectorModule, dplmtMgr, connection);
        this.connectorModule = connectorModule;
    }

    public ConnectorModuleController(
            final ResourceAdapterModule connectorModule,
            final RARModuleConfig connectorConfig,
            final DeploymentManager dplmtMgr,
            final AppserverConnectionSource connection) {
        super(connectorConfig, dplmtMgr, connection);
        this.connectorModule = connectorModule;
        this.connectorConfig = connectorConfig;
    }
    
    /**
     * Returns the properties of the application given the name.
     * 
     * @param propsToIgnore String properties to ignore.
     * @return All the application properties.
     */
    public java.util.Map getProperties(List propsToIgnore) {
        return getJ2EEAndConfigProperties(NodeTypes.CONNECTOR_MODULE, 
            connectorModule, connectorConfig, propsToIgnore);
    }
    
    
    /**
     * Sets the properties.
     *
     * @param attrname The name of the attribute.
     * @param value The value of the attribute to set. 
     *
     * @return updated Attribute
     */
    public javax.management.Attribute setProperty(final String attrName, final Object value) { 
        
        testIfServerInDebug();
        
        return ControllerUtil.setAttributeValue(connectorModule, connectorConfig, attrName, value, 
            getMBeanServerConnection());
    }
    
    /**
     *
     *
     */
    public String[] getResourceAdaptors() {
        
        testIfServerInDebug();
        
        return ControllerUtil.getComponentNamesFromMap(
            connectorModule.getContaineeMap(
                NodeTypes.getAMXJ2EETypeByNodeType(NodeTypes.RESOURCE_ADAPTER)));
    }
    
    
    /**
     *
     */
    public java.util.Map getResourceAdapterProperties(
            final String resAdapterName, final List propsToIgnore) {
        return getJ2EEAndConfigProperties(NodeTypes.RESOURCE_ADAPTER, 
            getResourceAdapterByName(resAdapterName), connectorConfig, propsToIgnore);
    }
    
    
    /**
     *
     */
    public javax.management.Attribute setResourceAdapterProperty(
            final String resAdapterName, final String attrName, 
            final Object value) {
        
        testIfServerInDebug();
        
        return ControllerUtil.setAttributeValue(
            getResourceAdapterByName(resAdapterName), attrName, value,
                getMBeanServerConnection());     
    }
    
    
    /**
     *
     *
     */
    public ResourceAdapter getResourceAdapterByName(final String name) {
        
        testIfServerInDebug();
        
        return (ResourceAdapter) connectorModule.getContainee(
            NodeTypes.getAMXJ2EETypeByNodeType(
                NodeTypes.RESOURCE_ADAPTER), name);
    }
    
    
    /**
     *
     *
     *
     */
    public boolean isEnabled() {
        testIfServerInDebug();
        boolean configEnabled = ((Enabled)connectorConfig).getEnabled();
        return ControllerUtil.calculateIsEnabled(connectorConfig, configEnabled);
    }
    
    
    /**
     *
     *
     *
     */
    public void setEnabled(boolean enabled) {
        testIfServerInDebug();
        ControllerUtil.getDeployedItemRefConfig(connectorConfig).setEnabled(enabled);
    }
    
    public J2EEDeployedObject getJ2EEObject() {
        return connectorModule;
    }
    
}
