/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.sun.bridge;

import java.io.File;


import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;

// necessary imports from App Server Jars: they need to be there at runtime:
import com.sun.enterprise.deployment.client.DeploymentFacilityFactory;
import com.sun.enterprise.deployment.client.DeploymentFacility;
import com.sun.enterprise.deployment.client.ServerConnectionIdentifier;

import com.sun.enterprise.deployment.deploy.shared.Archive;




/**
 *
 * @author  Ludo Champenois
 * small class to invoke App Server APIS to really do the directory based deployment.
 * It has to be a separate class because of class loader closure issues if the app server jars
 * are not around wihtin the  IDE.
 */
public class DirectoryDeploymentFacility {
    
    private String host,  user,  passwd;
    private int port;
    private boolean secure;
    // class name that might differ between AS 8 and AS 9...
    final static private String FILEARCHIVEA81= "com.sun.enterprise.deployment.archivist.FileArchive"; //NOI18N
    final static private String FILEARCHIVEA9=  "com.sun.enterprise.deployment.deploy.shared.FileArchive";//NOI18N
    
    
    public DirectoryDeploymentFacility(String host, int port, String user, String passwd,boolean secure) {
        this.host =host;
        this.port =port;
        this.user =user;
        this.passwd =passwd;
        this.secure = secure;
    }
    
    
    /**
     * @param targetModuleID
     * @return a progress object representing the incrmental dpeloy action.
     */
    final public ProgressObject  incrementalDeploy(  final TargetModuleID tmid) {
        ProgressObject progressObject = null;
         File dirLocation = AppServerBridge.getDirLocation( tmid);        
      //      long tt = System.currentTimeMillis();
     //   ClassLoader origClassLoader = origClassLoader=Thread.currentThread().getContextClassLoader();
        try {
     //       Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            
            Archive fa= getFileArchive(dirLocation);
            if (fa==null){
                IllegalStateException ise = new IllegalStateException("cannot find FileArchive class...");
                throw ise;
            }
            DeploymentFacility df = DeploymentFacilityFactory.getDeploymentFacility();
            ServerConnectionIdentifier sci = new ServerConnectionIdentifier();
            sci.setHostName(host);
            sci.setHostPort(port);
            sci.setUserName(user);
            sci.setPassword(passwd);
            sci.setSecure(secure);
            df.connect(sci);
            java.util.Properties deploymentOptions = new java.util.Properties();
            
            deploymentOptions.put("force","true");
            deploymentOptions.put("name", tmid.getModuleID());
            System.out.println("moduleID="+tmid.getModuleID());
            deploymentOptions.put("archiveName", dirLocation.getAbsolutePath());
            Target[] targets =new Target[1];
            targets[0] =  (Target)tmid;
            
            
            progressObject = df.deploy( targets, fa,  null, deploymentOptions );
//            System.out.println("redeploy in="+(System.currentTimeMillis()-tt));
            
        } catch(Exception e) {
            e.printStackTrace();
            IllegalStateException ise = new IllegalStateException(e.getMessage());
            ise.initCause(e);
            throw ise;
            
        } //finally {
       //     Thread.currentThread().setContextClassLoader(origClassLoader);
            
      //  }
        return progressObject;
    }
    
    
    
    
    
    
    
    /**
     * First time deployment file distribution.
     * Before this method is called the files are copied into the target
     * folder provided by plugin.
     * @param target target of deployment
     * @param file the destination directory for the given deploy app
     * @return the object for feedback on progress of deployment
     */
    public ProgressObject initialDeploy(Target target,  File file,  String moduleID) {
        
        
        ProgressObject progressObject = null;
        try{    
            Archive fa= getFileArchive(file);
            if (fa==null){
                IllegalStateException ise = new IllegalStateException("cannot find FileArchive class...");
                throw ise;
            }
            DeploymentFacility df = DeploymentFacilityFactory.getDeploymentFacility();
            ServerConnectionIdentifier sci = new ServerConnectionIdentifier();
            sci.setHostName(host);
            sci.setHostPort(port);
            sci.setUserName(user);
            sci.setPassword(passwd);
            sci.setSecure(secure);
            df.connect(sci);
            java.util.Properties deploymentOptions = new java.util.Properties();
            
            deploymentOptions.put("force","true");
            deploymentOptions.put("name", moduleID);
            System.out.println("moduleID="+moduleID);
            deploymentOptions.put("archiveName", file.getAbsolutePath());
            Target[] targets =new Target[1];
            targets[0] = target;
            
            progressObject = df.deploy( targets, fa,  null, deploymentOptions );
            
        } catch(Exception e) {
            e.printStackTrace();
            IllegalStateException ise = new IllegalStateException(e.getMessage());
            ise.initCause(e);
            throw ise;
            
        } 
        return progressObject;
    }
    
    private Archive getFileArchive(File file){
        try{
            Class fileArchiveClass;
            try {
                fileArchiveClass = this.getClass().getClassLoader().loadClass(FILEARCHIVEA81);
        java.util.logging.Logger.getLogger("javax.enterprise.system.tools.deployment").setLevel(java.util.logging.Level.SEVERE);
            } catch (ClassNotFoundException ex) {
                try {
                    fileArchiveClass = this.getClass().getClassLoader().loadClass(FILEARCHIVEA9);
                } catch (ClassNotFoundException ex2) {
                    ex2.printStackTrace();
                    return null;
                }
            }
            Object fa =fileArchiveClass.newInstance();
            
            java.lang.reflect.Method method =fileArchiveClass.getMethod("open", new Class[]{  String.class});//NOI18N
            method.invoke(fa, new Object[] {file.getAbsolutePath() });
            return (Archive)fa;
        }catch (Exception e){
            e.printStackTrace();
            return null;
        }
    }
    
    
    
    
    
    
    
    
    
}


