/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.sun.bridge;
import java.io.File;

import org.netbeans.modules.j2ee.deployment.plugins.api.IncrementalDeployment;
import org.netbeans.modules.j2ee.deployment.plugins.api.AppChangeDescriptor;


import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentConfigurationInterface;

/**
 *
 * @author  Ludo Champenois
 * @author Vince Kraemer
 */
public class DirectoryDeployment extends IncrementalDeployment {
    
    private SunDeploymentManagerInterface dm;


    /** Creates a new instance of DirectoryDeployment */
    public DirectoryDeployment() {
    }

   public DirectoryDeployment(DeploymentManager manager) {
       setDeploymentManager( manager);
    }


  
    
    
    
    /** Return a bogus name to satisfy the API. A file may be created by the
     * tool side. That file will be returned to this object in
     * writeDeploymentPlanFiles.  I will use it to find the directory for
     * writing the deployment descriptors and then delete it from that
     * directory.
     *
     * @param targetModuleID The module id
     * @return a single, unique file name.
     */
    public String[] getDeploymentPlanFileNames(ModuleType type) {
        String[] s;
        if (type==null){
            throw new IllegalArgumentException("invalid null argumment");
        }
        else if(type.equals(ModuleType.WAR)){
            s = new String[] { "WEB-INF/sun-web.xml" };
        }
        else if(type.equals(ModuleType.EJB)){
            s = new String[] { "META-INF/sun-ejb-jar.xml", "META-INF/sun-cmp-mappings.xml" };
        }
        else if(type.equals(ModuleType.EAR)){
            s = new String[] { "META-INF/sun-application.xml" };
        }
        else if(type.equals(ModuleType.RAR)){
            s = new String[] { "META-INF/sun-connector.xml" };
        }
        else if(type.equals(ModuleType.CAR)){
            s = new String[] { "META-INF/sun-application-client.xml" };
        }
      
        else{
            s = new String[] { ".timestamp" };
        }

        return s;
    }
    
    /** Determine where a module is going to be copied to.
     * If the target is not a local instance, return null.
     *
     * If the bug 4946433 still exists, return null.  This will disable
     * in-place deployment for J2EE apps.
     *
     * @param module The module being deployed
     * @return The name of a directory.
     */
    public File getDirectoryForModule(TargetModuleID module) {
        if (null == dm){
            throw new IllegalStateException("invalid dm value");
        }
//Ludo move to netbeans 5.0: not used
//        if (isWar(module)){  //use the same dir as the source web app.Even faster that copying binaries
//                return  null;   ////new for NB3.6: In palce deployment
//        }

//        if (dm.isLocal()) {
//            boolean isApp = isApp(module);
//            if (!isApp || module.getChildTargetModuleID() != null) {
//                appDir = new File(getApplicationsDir(), getModuleRelativePath(module));
//                if (! appDir.exists())
//                    appDir.mkdirs();
//            }
//            
//        }
//        return appDir;
        return null;
    }
    
    
    
    /**
     * @param manager
     */
    public void setDeploymentManager(DeploymentManager manager) {
        if (null == manager){
            throw new IllegalArgumentException("invalid null argumment");
        }
        if (manager instanceof SunDeploymentManagerInterface){
            this.dm = (SunDeploymentManagerInterface) manager;
        }
        else{
            throw new IllegalArgumentException("setDeploymentManager: Invalid manager type, expecting SunDeploymentManager and got "+manager.getClass().getName());
        }
    }
    
    
    /**
     * @param targetModuleID
     * @param appChangeDescriptor
     * @return a progress object representing the incrmental dpeloy action.
     */
    final public ProgressObject  incrementalDeploy( final TargetModuleID tmid, AppChangeDescriptor aCD) {
        
        DirectoryDeploymentFacility ddf = new DirectoryDeploymentFacility(dm.getHost(),dm.getPort(),dm.getUserName(),dm.getPassword(),dm.isSecure());
        return ddf. incrementalDeploy( tmid);
 
    }
    


 
    
    /**
     * Get the URI pointing to location of child module inside a application archive.
     * For a root module, service provider does not need to override this method.
     *
     * @param module TargetModuleID of the child module
     * @return its relative path within application archive, returns null by 
     * default (for standalone module)
     */
    public String getModuleUrl(TargetModuleID module){

        return AppServerBridge.getModuleUrl (module);
    }
    
    


    
    /**
     * First time deployment file distribution.
     * Before this method is called the files are copied into the target
     * folder provided by plugin.
     * @param target target of deployment
     * @param app the app to deploy
     * @param configuration server specific data for deployment
     * @param dir the destination directory for the given deploy app
     * @return the object for feedback on progress of deployment
     */     
    public ProgressObject initialDeploy(Target target, 
                DeployableObject deployableObject,
                DeploymentConfiguration deploymentConfiguration, 
                File file) {

      // System.out.println("initial Deploy: " +file);


        DirectoryDeploymentFacility ddf = new DirectoryDeploymentFacility(dm.getHost(),dm.getPort(),dm.getUserName(),dm.getPassword(),dm.isSecure());
        SunDeploymentConfigurationInterface s1dc =(SunDeploymentConfigurationInterface) deploymentConfiguration;
        s1dc.getContextRoot();
        String moduleID= getGoodDirNameFromContextRoot(s1dc.getDeploymentModuleName());
        return ddf. initialDeploy( target,    file , moduleID);
    }


    
    
    private String getGoodDirNameFromContextRoot(String contextRoot){
        String   moduleID;
        if (contextRoot==null){
            return "_default_"+this.hashCode() ;
        }
        if (contextRoot.equals("")){
            return  "_default_"+this.hashCode();
        }
        
        moduleID = contextRoot.replace(' ','_');
        
        // This moduleID will be later used to construct file path,
        // replace the illegal characters in file name
        //  \ / : * ? " < > | with _
        moduleID = moduleID.replace('\\', '_').replace('/', '_');
        moduleID = moduleID.replace(':', '_').replace('*', '_');
        moduleID = moduleID.replace('?', '_').replace('"', '_');
        moduleID = moduleID.replace('<', '_').replace('>', '_');
        moduleID = moduleID.replace('|', '_');
        
        // This moduleID will also be used to construct an ObjectName
        // to register the module, so replace additional special
        // characters , =  used in property parsing with -
        moduleID = moduleID.replace(',', '_').replace('=', '_');
        return moduleID;
        
    }
    /**
     * Whether the deployable object could be file deployed to the specified target
     * @param target target in question
     * @param deployable the deployable object in question
     * @return true if it is possible to do file deployment
     */
    public boolean canFileDeploy(Target target, DeployableObject deployableObject) {
        if (null == target){
            return false;
        }
        if (null == deployableObject){
            return false;
        }
        if (null == dm){
            return false;
        }
        if (deployableObject.getType() == ModuleType.EAR || 
                    deployableObject.getType() == ModuleType.EJB){
            return false;
        }
        return dm.isLocal();
    }
    
    /**
     * Return absolute path which the IDE will write the specified app or
     * stand-alone module contents to.
     * @param target target server of the deployment
     * @param app the app or stand-alone module to deploy
     * @param configuration server specific data for deployment
     * @return absolute path root directory for the specified app or
     * null if server can accept the deployment from an arbitrary directory.
     */
    
    public java.io.File getDirectoryForNewApplication(Target target, DeployableObject deployableObject, DeploymentConfiguration deploymentConfiguration) {
//        if (deployableObject.getType().equals(ModuleType.WAR)) {
//            return null;
//        }
//        if (deployableObject.getType().equals(ModuleType.EJB)) {
//            return null;
//        }
            return null;
    }

     /**
      * Return absolute path the IDE will write the app or stand-alone module content to.
      * Note: to use deployment name, implementation nees to override this.
      *
      * @param deploymentName name to use in deployment
      * @param target target server of the deployment
      * @param configuration server specific data for deployment
      * @return absolute path root directory for the specified app or null if
      * server can accept the deployment from an arbitrary directory.
      */
    public File getDirectoryForNewApplication(String deploymentName, Target target, DeploymentConfiguration configuration){
        
	return null;
        //return new File(getApplicationsDir().getAbsolutePath()+"/" +deploymentName);
        
    }
        /**
     * Return absolute path which the IDE will write the specified module contents to.
     * @param appDir the root directory of containing application
     * @param uri the URI of child module within the app
     * @param module the child module object to deploy
     * @param configuration server specific data for deployment
     * @return absolute path root directory for the specified module.
     */
    
    public java.io.File getDirectoryForNewModule(File file, String str, DeployableObject deployableObject, DeploymentConfiguration deploymentConfiguration) {
        System.out.println("    getDirectoryForNewModule" +file+str);
        System.out.println("     getDirectoryForNewModule" +deploymentConfiguration);
        System.out.println("        getDirectoryForNewModule" +deployableObject);
        return new File("C:\\tmp\\ludo222");
    }

 
}


