/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.sun.bridge;

import java.util.ResourceBundle;

import org.openide.util.NbBundle;

/**
 * This class displays the certificate
 *
 * @author  Ludo
 */

final class CertificatePanel extends javax.swing.JPanel {
    
    /** Creates new form CertificatePanel */
    public CertificatePanel(String certificate) {
        initComponents();
        initAccessibility();
        try {
            jEditorPane1.setText(certificate);
        } catch (Exception exc) {
            //Problem with locating file
            System.err.println("Exception: " + exc.getMessage()); //NOI18N
            exc.printStackTrace();
        }
    }
    
    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName
        (bundle.getString("ACSN_CertificatePanel"));
        this.getAccessibleContext().setAccessibleDescription
        (bundle.getString("ACSD_CertificatePanel"));
        
        jEditorPane1.getAccessibleContext().setAccessibleName
        (bundle.getString("ACSN_EditorPane"));
        jEditorPane1.getAccessibleContext().setAccessibleDescription
        (bundle.getString("ACSD_EditorPane"));
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jScrollPane1 = new javax.swing.JScrollPane();
        jEditorPane1 = new javax.swing.JEditorPane();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.Y_AXIS));

        setBorder(javax.swing.BorderFactory.createEmptyBorder(12, 12, 0, 11));
        jEditorPane1.setEditable(false);
        jEditorPane1.setPreferredSize(new java.awt.Dimension(500, 500));
        jScrollPane1.setViewportView(jEditorPane1);

        add(jScrollPane1);

    }
    // </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JEditorPane jEditorPane1;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables

    private static final ResourceBundle bundle = NbBundle.getBundle(CertificatePanel.class);
}
