/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * ConnectionTabVisualPanel.java
 *
 * Created on January 7, 2004
 */

package org.netbeans.modules.j2ee.sun.ide.j2ee.ui;

import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.openide.util.NbBundle;

import org.netbeans.modules.j2ee.sun.ide.j2ee.DeploymentManagerProperties;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;

/** A single panel for a wizard - the GUI portion.
 *
 * @author nityad
 */
public class ConnectionTabVisualPanel extends javax.swing.JPanel {
    
    /** The wizard panel descriptor associated with this GUI panel.
     * If you need to fire state changes or something similar, you can
     * use this handle to do so.
     */
    
    private final DeploymentManagerProperties targetData;
    private final SunDeploymentManagerInterface dm;
    
    /** Create the wizard panel and set up some basic properties. */
    public ConnectionTabVisualPanel( DeploymentManager dm) {
        
        this.dm = (SunDeploymentManagerInterface)dm;
        targetData = new DeploymentManagerProperties(dm);

        initComponents();
        InstanceProperties ips = targetData.getInstanceProperties();
        String url = (String) ips.getProperty("url"); // NOI18N
        int dex = url.indexOf("::");
        if (dex > -1){
            url = url.substring(dex+2);
        }
        socketField.setText(url);
        userNameField.setText(targetData.getUserName());
        passwordField.setText(targetData.getPassword());
        domainField.setText(targetData.getDomainName());
        domainLocField.setText(targetData.getLocation());
        enableHttpMonitor.setSelected(Boolean.valueOf(targetData.getHttpMonitorOn()).booleanValue());
        syncHttpProxies.setSelected(targetData.isSyncHttpProxyOn());
        // Provide a name in the title bar.
        setName(NbBundle.getMessage(ConnectionTabVisualPanel.class, "TITLE_AddUserDefinedLocalServerPanel"));
        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        socketField = new javax.swing.JTextField();
        userNameField = new javax.swing.JTextField();
        passwordField = new javax.swing.JPasswordField();
        domainField = new javax.swing.JTextField();
        domainLocField = new javax.swing.JTextField();
        portLabel = new javax.swing.JLabel();
        userNameLabel = new javax.swing.JLabel();
        userPasswordLabel = new javax.swing.JLabel();
        domainLabel = new javax.swing.JLabel();
        domainLocLabel = new javax.swing.JLabel();
        msgLabel = new javax.swing.JLabel();
        enableHttpMonitor = new javax.swing.JCheckBox();
        syncHttpProxies = new javax.swing.JCheckBox();

        getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("Step_ChooseUserDefinedLocalServer"));
        getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("AddUserDefinedLocalServerPanel_Desc"));
        socketField.setColumns(30);
        socketField.setEditable(false);
        socketField.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("LBL_AdminPort"));
        socketField.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("ACSD_AdminPort"));

        userNameField.setColumns(30);
        userNameField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                userNameFieldKeyReleased(evt);
            }
        });

        userNameField.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("LBL_Username"));
        userNameField.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("ACSD_Username"));

        passwordField.setColumns(30);
        passwordField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                passwordFieldKeyReleased(evt);
            }
        });

        passwordField.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("LBL_Pw"));
        passwordField.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("ACSD_Pw"));

        domainField.setColumns(30);
        domainField.setEditable(false);
        domainField.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("LBL_Domain"));
        domainField.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("ACSD_Domain"));

        domainLocField.setColumns(30);
        domainLocField.setEditable(false);
        domainLocField.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("LBL_InstallRoot"));
        domainLocField.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("ACSD_InstallRoot"));

        portLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("LBL_AdminSocket_Mnemonic").charAt(0));
        portLabel.setLabelFor(socketField);
        portLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("LBL_AdminSocket"));
        portLabel.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("LBL_AdminSocket"));
        portLabel.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("ASCD_AdminSocket"));

        userNameLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("LBL_Username_Mnemonic").charAt(0));
        userNameLabel.setLabelFor(userNameField);
        userNameLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("LBL_Username"));
        userNameLabel.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("LBL_Username"));
        userNameLabel.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("ACSD_Username"));

        userPasswordLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("LBL_Pw_Mnemonic").charAt(0));
        userPasswordLabel.setLabelFor(passwordField);
        userPasswordLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("LBL_Pw"));
        userPasswordLabel.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("LBL_Pw"));
        userPasswordLabel.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("ACSD_Pw"));

        domainLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("LBL_Domain_Mnemonic").charAt(0));
        domainLabel.setLabelFor(domainField);
        domainLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("LBL_Domain"));
        domainLabel.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("LBL_Domain"));
        domainLabel.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("ACSD_Domain"));

        domainLocLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("LBL_InstallRoot_Mnemonic").charAt(0));
        domainLocLabel.setLabelFor(domainLocField);
        domainLocLabel.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("LBL_DomainRoot"));
        domainLocLabel.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("LBL_InstallRoot"));
        domainLocLabel.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("ACSD_InstallRoot"));

        msgLabel.setForeground(new java.awt.Color(89, 79, 191));

        enableHttpMonitor.setMnemonic(org.openide.util.NbBundle.getBundle(ConnectionTabVisualPanel.class).getString("MNE_Connection").charAt(0));
        enableHttpMonitor.setText(org.openide.util.NbBundle.getBundle(ConnectionTabVisualPanel.class).getString("LBL_EnableHttpMonitor"));
        enableHttpMonitor.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                enableHttpMonitorActionPerformed(evt);
            }
        });

        enableHttpMonitor.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("ACSD_EnableHttpMonitor"));

        syncHttpProxies.setText(org.openide.util.NbBundle.getBundle(ConnectionTabVisualPanel.class).getString("LBL_SyncHttpProxy"));
        syncHttpProxies.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                syncHttpProxiesActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, msgLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 446, Short.MAX_VALUE)
                    .add(enableHttpMonitor)
                    .add(syncHttpProxies)
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                            .add(userNameLabel)
                            .add(portLabel)
                            .add(userPasswordLabel)
                            .add(domainLocLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(domainLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(domainField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 334, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, domainLocField)
                            .add(layout.createSequentialGroup()
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(socketField))
                            .add(passwordField)
                            .add(userNameField))))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(socketField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 20, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(portLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(userNameField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 20, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(userNameLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 19, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(passwordField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 14, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(userPasswordLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 19, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(domainLocLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 19, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(domainLocField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 20, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(domainField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 20, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(domainLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 19, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(enableHttpMonitor)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(syncHttpProxies)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(msgLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 36, Short.MAX_VALUE)
                .addContainerGap())
        );

        layout.linkSize(new java.awt.Component[] {passwordField, userNameField}, org.jdesktop.layout.GroupLayout.VERTICAL);

    }// </editor-fold>//GEN-END:initComponents
    
    private void syncHttpProxiesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_syncHttpProxiesActionPerformed
        targetData.setSyncHttpProxyOn(syncHttpProxies.isSelected());
        if(syncHttpProxies.isSelected()) {
            msgLabel.setText(NbBundle.getMessage(ConnectionTabVisualPanel.class, "Msg_httpProxyStatusChangedAtRestart"));
        }
    }//GEN-LAST:event_syncHttpProxiesActionPerformed
    
    private void enableHttpMonitorActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_enableHttpMonitorActionPerformed
        targetData.setHttpMonitorOn(""+enableHttpMonitor.isSelected());
        msgLabel.setText(NbBundle.getMessage(ConnectionTabVisualPanel.class, "Msg_httpMonitorStatusChangedAtRestart"));
        
    }//GEN-LAST:event_enableHttpMonitorActionPerformed
    
    private void passwordFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_passwordFieldKeyReleased
//        char[] passWd = passwordField.getPassword();
//        String adminPassword = new String(passWd);
//        targetData.setPassword(adminPassword);
//        dm.setPassword(adminPassword);
        
    }//GEN-LAST:event_passwordFieldKeyReleased
    
    private void userNameFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_userNameFieldKeyReleased
//        String userName = userNameField.getText();
//        targetData.setUserName(userName);
//        dm.setUserName(userName);
        
    }//GEN-LAST:event_userNameFieldKeyReleased
    /* store username and passord in the model
     * called when the tab is gone
     **/
    public void syncUpWithModel(){
        String userName = userNameField.getText();
        targetData.setUserName(userName);
        dm.setUserName(userName);        
        char[] passWd = passwordField.getPassword();
        String adminPassword = new String(passWd);
        targetData.setPassword(adminPassword);
        dm.setPassword(adminPassword);
    }
    
    public boolean isValid(){
        boolean retVal = true;
        if((userNameField.getText() == null) || (userNameField.getText().trim().equals(""))) {//NOI18N
            msgLabel.setText(NbBundle.getMessage(ConnectionTabVisualPanel.class, "Msg_ValidUser"));
            retVal = false;
        } //else {
        
//        char[] passWd = passwordField.getPassword();
//        String userPassword = new String(passWd);
        return retVal;
    }
    
    
    
    
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField domainField;
    private javax.swing.JLabel domainLabel;
    private javax.swing.JTextField domainLocField;
    private javax.swing.JLabel domainLocLabel;
    private javax.swing.JCheckBox enableHttpMonitor;
    private javax.swing.JLabel msgLabel;
    private javax.swing.JPasswordField passwordField;
    private javax.swing.JLabel portLabel;
    private javax.swing.JTextField socketField;
    private javax.swing.JCheckBox syncHttpProxies;
    private javax.swing.JTextField userNameField;
    private javax.swing.JLabel userNameLabel;
    private javax.swing.JLabel userPasswordLabel;
    // End of variables declaration//GEN-END:variables
    
}
