/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee.ui;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

final class AddInstanceVisualInstancePanel extends JPanel {
    
    /**
     * Creates new form AddInstanceVisualInstancePanel
     */
    AddInstanceVisualInstancePanel() { 
        initComponents();
    }
    
    void setDomainsList(Object[] domainsList) {
        if (domainsList != null) { 
            instanceSelector.setModel(new javax.swing.DefaultComboBoxModel(domainsList));
        } else {
            instanceSelector.setModel(new javax.swing.DefaultComboBoxModel());
        }
    }
        
    String getDomainDir() {
        String tmp = (String) instanceSelector.getSelectedItem();
        if (null == tmp)
            return null;
        int firstParen = tmp.lastIndexOf('(');
        int lastParen = tmp.lastIndexOf(')');
        if (firstParen < 0) {
            ErrorManager.getDefault().log(ErrorManager.ERROR,
                    NbBundle.getMessage(AddInstanceVisualInstancePanel.class,
                    "ERRMSG_PARSE_DOMAIN_DIR", tmp));
            return null;
        }
        if (lastParen < 0) {
            ErrorManager.getDefault().log(ErrorManager.ERROR,
                    NbBundle.getMessage(AddInstanceVisualInstancePanel.class,
                    "ERRMSG_PARSE_DOMAIN_DIR", tmp));
            return null;
        }
        if (lastParen < firstParen) {
            ErrorManager.getDefault().log(ErrorManager.ERROR,
                    NbBundle.getMessage(AddInstanceVisualInstancePanel.class,
                    "ERRMSG_PARSE_DOMAIN_DIR", tmp));
            return null;
        }
        return tmp.substring(firstParen+1,lastParen);
    }

    public String getName() {
        return NbBundle.getMessage(AddInstanceVisualInstancePanel.class, 
                "StepName_PickDefaultInstance");                                // NOI18N
    }
    
    // Event Handling
    //
    private Set/*<ChangeListener.*/ listenrs = new HashSet/*<Changelisteners.*/();

    void addChangeListener(ChangeListener l) {
        synchronized (listenrs) {
            listenrs.add(l);
        }
    }
    
    void removeChangeListener(ChangeListener l ) {
        synchronized (listenrs) {
            listenrs.remove(l);
        }
    }

    private void fireChangeEvent() {
        Iterator it;
        synchronized (listenrs) {
            it = new HashSet(listenrs).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged (ev);
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        description = new javax.swing.JLabel();
        instanceSelectorLabel = new javax.swing.JLabel();
        instanceSelector = new javax.swing.JComboBox();
        spacingHack = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        description.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("TXT_instancePanelDescription"));
        description.setFocusable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        add(description, gridBagConstraints);
        description.getAccessibleContext().setAccessibleName("Select the default domain to register");

        instanceSelectorLabel.setDisplayedMnemonic(org.openide.util.NbBundle.getMessage(AddInstanceVisualInstancePanel.class, "MNM_instanceSelectorLabel").charAt(0));
        instanceSelectorLabel.setLabelFor(instanceSelector);
        instanceSelectorLabel.setText(org.openide.util.NbBundle.getMessage(AddInstanceVisualInstancePanel.class, "LBL_instanceSelectorLabel"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 5, 6);
        add(instanceSelectorLabel, gridBagConstraints);

        instanceSelector.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                instanceSelectorActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 5, 0);
        add(instanceSelector, gridBagConstraints);
        instanceSelector.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("DSC_instanceSelector"));

        spacingHack.setEnabled(false);
        spacingHack.setFocusable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        add(spacingHack, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents

    private void instanceSelectorActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_instanceSelectorActionPerformed
        fireChangeEvent();
    }//GEN-LAST:event_instanceSelectorActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel description;
    private javax.swing.JComboBox instanceSelector;
    private javax.swing.JLabel instanceSelectorLabel;
    private javax.swing.JLabel spacingHack;
    // End of variables declaration//GEN-END:variables

}

