/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.jboss4.config;

import java.io.File;
import java.util.Set;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import org.netbeans.modules.j2ee.deployment.common.api.OriginalCMPMapping;
import org.netbeans.modules.j2ee.deployment.plugins.api.ConfigurationSupport;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;




/**
 * ConfigurationSupport implementation.
 *
 * @author sherold
 */
public class ConfigurationSupportImpl extends ConfigurationSupport {

    public void setMappingInfo(DeploymentConfiguration config, OriginalCMPMapping[] mappings) {
    }

    public void ensureResourceDefined(DeploymentConfiguration config, DDBean bean) {
    }

    public String getWebContextRoot(DeploymentConfiguration config, DeployableObject deplObj) 
    throws ConfigurationException {
        if (config.getDeployableObject().getType() != ModuleType.WAR) {
            throw new ConfigurationException("This operation is supported only by the WAR modules"); // NOI18N
        }
        if (!(config instanceof WarDeploymentConfiguration)) {
            throw new IllegalArgumentException("Wrong DeploymentConfiguration instance " + config.getClass().getName()); // NOI18N
        }
        return ((WarDeploymentConfiguration)config).getContextPath();
    }

    public void setWebContextRoot(DeploymentConfiguration config, DeployableObject deplObj, String contextRoot) 
    throws ConfigurationException {
        if (config.getDeployableObject().getType() != ModuleType.WAR) {
            throw new ConfigurationException("This operation is supported only by the WAR modules."); // NOI18N
        }
        if (!(config instanceof WarDeploymentConfiguration)) {
            throw new IllegalArgumentException("Wrong DeploymentConfiguration instance " + config.getClass().getName()); // NOI18N
        }
        ((WarDeploymentConfiguration)config).setContextPath(contextRoot);
    }
    
    public void initConfiguration(DeploymentConfiguration config, File[] files,
            File resourceDir, boolean keepUpdated) throws ConfigurationException {
        if (!(config instanceof JBDeploymentConfiguration)) {
            throw new IllegalArgumentException("Wrong DeploymentConfiguration instance " + config.getClass().getName()); // NOI18N
        }
        if (files == null || files.length != 1) {
            throw new IllegalArgumentException("Invalid value of the files argument."); // NOI18N
        }
        ModuleType type = config.getDeployableObject().getType();
        if (type == ModuleType.WAR) {
            ((WarDeploymentConfiguration)config).init(files[0], resourceDir);
        } else if (type == ModuleType.EAR) {
            ((EarDeploymentConfiguration)config).init(files[0]);
        } else if (type == ModuleType.EJB) {
            ((EjbDeploymentConfiguration)config).init(files[0], resourceDir);
        } else if (type == ModuleType.CAR) {
            ((CarDeploymentConfiguration)config).init(files[0], resourceDir);
        } else {
            assert true : "Unsupported module type: " + type.toString(); // NOI18N
        }
    }
    
    public void disposeConfiguration(DeploymentConfiguration config) {
        if (!(config instanceof JBDeploymentConfiguration)) {
            throw new IllegalArgumentException("Wrong DeploymentConfiguration instance " + config.getClass().getName()); // NOI18N
        }
    }
    
    public void updateResourceDir(DeploymentConfiguration config, File resourceDir) {
        // no op
    }
    
    public Set<Datasource> getDatasources(DeploymentConfiguration config) {
        Set<Datasource> projectDS = ((JBDeploymentConfiguration)config).getDatasources();
        return projectDS;
    }    
    
    public boolean isDatasourceCreationSupported() {
        return true;
    }
    
    public Datasource createDatasource(DeploymentConfiguration config, String jndiName, String  url, String username, String password, String driver) 
    throws OperationUnsupportedException, ConfigurationException, DatasourceAlreadyExistsException
    {
        JBossDatasource ds = ((JBDeploymentConfiguration)config).createDatasource(jndiName, url, username, password, driver);
        return ds;
    }
    
}
