/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
import java.io.*; 
import book.*;

import org.netbeans.modules.schema2beans.*;


public class TestValid extends BaseTest
{ 
    public static void main(String[] argv) {
        BaseTest o = new TestValid();
        if (argv.length > 0)
            o.setDocumentDir(argv[0]);
        try {
            o.run();
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
    
	public void run()
		throws Exception
	{
        readDocument();
        
        //    Create the graph from the input stream 
        Book book = Book.createGraph(this.doc);

		out("Current XML document:");
		book.write(System.out);

		out("Should add paperback after chapter:");
		book.setPaperback(true);
		book.write(System.out);

		out("Should add summary after paperback:");
		book.setSummary("Summary of the book");
		book.write(System.out);

		out("Should add chapter before paperback");
		Chapter c = new Chapter();
		c.setTitle("title1");
		book.addChapter(c);
		c = new Chapter();
		c.setTitle("title2");
		book.addChapter(c);
		c = new Chapter();
		c.setTitle("title3");
		book.addChapter(c);
		c = new Chapter();
		c.setTitle("title4");
		book.addChapter(c);
		c = new Chapter();
		c.setTitle("title5");
		book.addChapter(c);

		//	Mix to index/Dom Node to test the property indexed case
		Chapter[] c2 = book.getChapter();
		c = c2[2];
		c2[2] = c2[0];
		c2[0] = c;
		c = c2[3];
		c2[3] = c2[1];
		c2[1] = c;
		book.setChapter(c2);
		
		out(book);

		out("Should add title as the first property of book:");
		book.setTitle("Title of the book");
		out(book);
		
		out("Should add price as the last property of book:");
		book.setPrice("19.99");
		out(book);
		
		out("Should add isbn before the price:");
		book.setIsbn("120394857");
		out(book);

		out("Should add ending at the end of the chapter:");
		c = book.getChapter(0);
		c.setEnding("And this is how this chapter ends.");
		out(book);
		
		out("Should add conclusion before the ending");
		c.setConclusion("And this concludes this chapter.");
		out(book);

		out("Should add Note with year before copyright");
		Note n = new Note();
		n.setYear("2000");
		n.setCopyright("1997");
		book.setNote(n);
		out(book);

		out("Should set Note with date before copyright");
		n = new Note();
		n.setDate("2001");
		n.setCopyright("1996");
		book.setNote(n);
		out(book);
	} 
}

