/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 *	TestPurchaseOrder - test the basic features.
 *
 *	The following test assumes that we know the content of the
 *	graph as we get elements, add and change them. Therefore, the TestPurchaseOrder.xml
 *	file and this java test should be kept in sync.
 *
 * 	Test the following:
 *
 *	single String: get/set/remove/set/get
 *	boolean (from true): get/set true/get/set false/get/set true/get
 *	boolean (from false): get/set false/get/set true/get/set false/get
 *	String[]: get/set (null & !null)/add/remove
 *	Bean: remove/set(null)/create bean and graph of beans/set/add
 *
 */

import java.io.*;
import java.util.*;
import org.w3c.dom.*;

import purchaseorder.*;


public class TestPurchaseOrder extends BaseTest {
    public static void main(String[] argv) {
        TestPurchaseOrder o = new TestPurchaseOrder();
        if (argv.length > 0)
            o.setDocumentDir(argv[0]);
        try {
            o.run();
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
    
    public void run() throws Exception {
        PurchaseOrder po;

        this.readDocument();

        out("creating the bean graph");
        po = PurchaseOrder.read(doc);
	
        //	Check that we can read the graph an it is complete
        out("bean graph created");
        po.write(out);

        out("Adjusting shipTo");
        USAddress shipTo = new USAddress();
        po.setShipTo(shipTo);
        shipTo.setCountry("B&B's are us");
        shipTo.setName("To you & me");
        po.write(out);

        out("Adding a Daffodil");
        Items items = po.getItems();
        Item item = new Item();
        item.setProductName("Daffodil");
        item.setQuantity(3);
        item.setUSPrice(new java.math.BigDecimal("1.00"));
        item.setComment("Yellow & Green");
        int position = items.addItem(item);
        po.write(out);

        check(items.getItem(position) == item, "addItem returned correct position");

        out("Removing that Daffodil");
        items.removeItem(item);
        po.write(out);

        Item[] itemsArray = items.getItem();
        /*
        out(""+itemsArray.length);
        check(itemsArray.length == 2, "we should have 2 items now");
        */
        check(items.sizeItem() == 2, "sizeItem should return 2");

        PurchaseOrder po2 = new PurchaseOrder(po);
        check(po != po2, "po should not be po2");
        check(po.equals(po2), "po should equal po2");
        check(po2.equals(po), "po2 should equal po");
        /*
        po.write(out);
        po2.write(out);
        */

        po._setSchemaLocation("flurp");
        po.write(out);
    }
}
