/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 *	TestDupInternalNames - test what happens when different complexTypes
 *                         have the same named element declaration
 *                         inside of them.  Duplicate type names should
 *                         get renamed.
 *
 *	The following test assumes that we know the content of the
 *	graph as we get elements, add and change them. Therefore, the TestDupInternalNames.xml
 *	file and this java test should be kept in sync.
 *
 */

import java.io.*;
import java.util.*;
import org.w3c.dom.*;
import java.math.*;

import root.*;


public class TestDupInternalNames extends BaseTest {
    public static void main(String[] argv) {
        TestDupInternalNames o = new TestDupInternalNames();
        if (argv.length > 0)
            o.setDocumentDir(argv[0]);
        try {
            o.run();
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
    
    public void run() throws Exception {
        Root dupInternalNames;

        this.readDocument();

        out("creating the bean graph");
        dupInternalNames = Root.read(doc);
	
        //	Check that we can read the graph an it is complete
        out("bean graph created");
        dupInternalNames.write(out);

        AnalogInput in = dupInternalNames.getIn();
        in.setPointNumber(new BigInteger("5"));
        AnalogOutput o = dupInternalNames.getOut();
        o.setPointNumber(new BigInteger("89"));
        dupInternalNames.write(out);
    }
}
