/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.schema2beansdev.gen;

import java.util.*;
import java.io.*;

public class WriteIfDifferentOutputStream extends OutputStream {
    private RandomAccessFile randFile;
    private long initialRandFileLength;
    private boolean justWrite = false;
    
    public WriteIfDifferentOutputStream(RandomAccessFile randFile) throws IOException {
        this.randFile = randFile;
        this.initialRandFileLength = randFile.length();
    }

    public WriteIfDifferentOutputStream(String filename) throws IOException {
        this(new RandomAccessFile(filename, "rw"));	// NOI18N
    }

    public WriteIfDifferentOutputStream(File file) throws IOException {
        this(new RandomAccessFile(file, "rw"));	// NOI18N
    }

    public void write(int b) throws IOException {
        if (justWrite) {
            randFile.write(b);
            return;
        }
        long fp = randFile.getFilePointer();
        if (fp + 1 > initialRandFileLength) {
            justWrite = true;
            randFile.write(b);
            return;
        }
        int fromFile = randFile.read();
        if (fromFile != b) {
            //System.out.println("different: fromFile="+fromFile+" b="+b);
            randFile.seek(fp);
            randFile.write(b);
            justWrite = true;
            return;
        }
    }

    private byte[] writeBuf;
    private int lastLen = -1;
    public void write(byte[] b, int off, int len) throws IOException {
        if (justWrite) {
            randFile.write(b, off, len);
            return;
        }
        long fp = randFile.getFilePointer();
        if (fp + len > initialRandFileLength) {
            justWrite = true;
            randFile.write(b, off, len);
            return;
        }
        if (len > lastLen) {
            // Allocate a new buffer only if the last one wasn't big enough.
            writeBuf = new byte[len];
            lastLen = len;
        }
        randFile.read(writeBuf, 0, len);
        for (int i = off, j = 0; j < len; ++i, ++j) {
            if (writeBuf[j] != b[i]) {
                //System.out.println("different: i="+i+" j="+j);
                randFile.seek(fp);
                randFile.write(b, off, len);
                justWrite = true;
                return;
            }
        }
    }

    /*
      public void flush() throws IOException {
      randFile.flush();
      }
    */

    /**
     * At this point, have we changed the file?
     * It's possible to not change a file until close() is called.
     */
    public boolean isChanged() {
        return justWrite;
    }

    public void close() throws IOException {
        // Truncate it.
        //System.out.println("truncating to "+randFile.getFilePointer());
        if (randFile.getFilePointer() < randFile.length()) {
            justWrite = true;
            randFile.setLength(randFile.getFilePointer());
        }
        randFile.close();
    }
}
