/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.schema2beansdev;

import java.util.*;
import java.io.*;

public abstract class GeneralParser  {
    // filename of the schema
    protected File 		filename;
    // If schemaIn is set, then it overrides filename as where to get the
    // XML Schema
    protected InputStream         schemaIn = null;

    //	The file stream that we are reading from
    protected Reader 	reader = null;

    // If we only have the InputStream, then the inputURI will help
    // us find relative URI's if anything gets included or imported.
    protected String inputURI = null;

    protected void startupReader() throws java.io.IOException {
	    if (schemaIn == null)
            reader = new FileReader(filename);
	    else
            reader = new InputStreamReader(schemaIn);
    }

    protected void shutdownReader() throws java.io.IOException {
        reader.close();
    }

    public void setInputURI(String uri) {
        inputURI = uri;
    }

    protected String getReaderURI() {
        if (inputURI != null)
            return inputURI;
        if (filename != null)
            return filename.toURI().toString();
        return schemaIn.toString();
    }
}
