/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.refactoring.vcs;

import java.awt.Component;
import java.util.Collection;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/**
 *
 * @author  Jan Becicka
 */
public class CheckoutPanel extends javax.swing.JPanel {
    
    /**
     * Creates new form CheckoutPanel
     * 
     */
    public CheckoutPanel(Collection files) {
        initComponents();
        fileList.setListData(files.toArray());
        fileList.setCellRenderer(new DefaultListCellRenderer() {
                public Component getListCellRendererComponent(
                        JList list,
                        Object value,
                        int index,
                        boolean isSelected,
                        boolean cellHasFocus) 
                  {
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    setText("<html>" + ((FileObject) value).getNameExt() + " <font color=#707070>(" + FileUtil.getFileDisplayName((FileObject) value) + ")</font></html>"); //NOI18N
                    return this;
                }
                
                
        });
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        topLabel = new javax.swing.JLabel();
        progressBar = new javax.swing.JProgressBar();
        scrollPane = new javax.swing.JScrollPane();
        fileList = new javax.swing.JList();

        setLayout(new java.awt.BorderLayout(0, 6));

        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(12, 12, 11, 11)));
        org.openide.awt.Mnemonics.setLocalizedText(topLabel, org.openide.util.NbBundle.getMessage(CheckoutPanel.class, "LBL_FilesToUpdate"));
        add(topLabel, java.awt.BorderLayout.NORTH);

        add(progressBar, java.awt.BorderLayout.SOUTH);

        scrollPane.setViewportView(fileList);

        add(scrollPane, java.awt.BorderLayout.CENTER);

    }
    // </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JList fileList;
    private javax.swing.JProgressBar progressBar;
    private javax.swing.JScrollPane scrollPane;
    private javax.swing.JLabel topLabel;
    // End of variables declaration//GEN-END:variables
    
}
