/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.test.refactoring.signature;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.StyledDocument;
import junit.textui.TestRunner;
import org.netbeans.modules.refactoring.api.ChangeParametersRefactoring;
import org.netbeans.modules.refactoring.api.ChangeParametersRefactoring.ParameterInfo;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.junit.AssertionFailedErrorException;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.test.refactoring.Utility;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;

/**
 *
 * @author  Pavel Flaska
 */
public class Signature2Test extends NbTestCase {
    
    // filetable is filed by initializer - contain pairs of names for
    // comparing results - second index value 0 represents generated file,
    // second index value 1 represents golden file.
    static String[][] filetable;
    
    static {
        // init filetable
        final String[] filename = { 
            "Signature2Owner",
            "Signature2User1",
            "Signature2User2"
        };
        final String prefix = "org/netbeans/test/signature/";
        filetable = new String[filename.length][2];
        for (int i = 0; i < filename.length; i++) {
            filetable[i][0] = prefix + filename[i] + ".java";
            filetable[i][1] = filename[i] + ".pass";
        }
    };
    
    /** Creates a new instance of Signature2Test */
    public Signature2Test() {
        super("Signature2Test");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(Signature2Test.class);
        return suite;
    } 
    
    JavaClass clazz;
    String cbn;
    JavaModelPackage pkg;
    Method sigMethod;
    
    protected void setUp() {
        clazz = (JavaClass) Utility.findClass("org.netbeans.test.signature.Signature2Owner");
        pkg = (JavaModelPackage) clazz.refOutermostPackage();

        // get a method which signature will be changed
        sigMethod = (Method) clazz.getFeatures().get(1);
    }
    
    public void testSwapParameters() throws FileStateInvalidException, IOException {
        // initializer new table for parameters
        List origPars = sigMethod.getParameters();
        ParameterInfo[] aParamTable = new ParameterInfo[origPars.size()];
        // swap it
        aParamTable[0] = new ParameterInfo(1, null, null, null);
        aParamTable[1] = new ParameterInfo(0, null, null, null);
        // initialize refactoring
        ChangeParametersRefactoring refactoring = new ChangeParametersRefactoring(sigMethod);
        refactoring.preCheck();
        refactoring.setParameterInfo(aParamTable);
        refactoring.setModifiers(Modifier.PUBLIC);
        refactoring.checkParameters();
        RefactoringSession result = RefactoringSession.create("change method signature");
        refactoring.prepare(result);
        result.doRefactoring(true);
        assertFiles();
    }
    

    public void assertFiles() throws FileStateInvalidException, IOException {
        // assert all affected files
        for (int i = 0; i < filetable.length; i++) {
            assertFile(Utility.getFile(getDataDir(), filetable[i][0]), getGoldenFile(filetable[i][1]), getWorkDir());
        }
    }
    
}
