/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.test.refactoring.safedelete;
import java.io.IOException;
import java.util.Collections;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.test.refactoring.*;
import org.openide.filesystems.FileStateInvalidException;


/*
 * SafeDeleteFieldTest .java
 * Created on May 24, 2005, 8:37 PM
 *
 * This whole class should've been one extra method in SafeDeleteRefactoringTest
 * But when run in conjunction with SafeDeleteRefactoringTest.testSafeDeleteMethod(), 
 * testSafeDeleteField isn't behaving as expected :-(
 *
 * @author Bharath Ravikumar
 */
public class SafeDeleteFieldTest extends NbTestCase{
    
    private JavaClass targetClass;
    private static final String TARGET_FILE = "org/netbeans/test/safedelete/SelfSuffClass.java";
    /**
     * Creates a new instance of SafeDeleteFieldTest
     */
    public SafeDeleteFieldTest() {
        super("SafeDeleteFieldTest");
    }
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite(SafeDeleteFieldTest.class);
        return suite;
    }
    
    protected void setUp(){
        targetClass = Utility.findClass("org.netbeans.test.refactoring.safedelete.SelfSuffClass");
    }
    
    /**
     * Compares the partially refactored file (without referredMethod references) with the golden files
     * using utility methods from {@link org.netbeans.junit.NbTestCase}
     */
    public void compareGoldenFile(String goldenFileName) throws FileStateInvalidException, IOException {
        assertFile(Utility.getFile(getDataDir(), TARGET_FILE), getGoldenFile(goldenFileName), getWorkDir());
    }
    
    public void testSafeDeleteField() throws FileStateInvalidException, IOException {
        Field fieldInReferringClass = targetClass.getField("refClass", true);
        SafeDeleteRefactoring safeDeleteRefField = new SafeDeleteRefactoring(new Element[]{fieldInReferringClass});
        RefactoringSession result = null;
        assertNull(safeDeleteRefField.checkParameters());
        result = RefactoringSession.create("SafeDelete Field");
        //The field in ReferringClass has references. Hence, there must be a Problem returned
        Object prepResult = safeDeleteRefField.prepare(result);
        assertNotNull(prepResult);

        //Delete the method that refers to the field in the same class
        deleteReferringMethod();
        assertNull(safeDeleteRefField.checkParameters());
        result = RefactoringSession.create("SafeDelete Referring Method");
        //The field in ReferringClass now has no references. 
        //Hence, there must be no Problem returned
        assertNull(safeDeleteRefField.prepare(result));
        assertNull(result.doRefactoring(true));
        compareGoldenFile("PlainReferringClass.pass");
    }
    
//    --private helper methods follow--
    private void deleteReferringMethod() {
        Method referringMethod = targetClass.getMethod("referringMethod", Collections.EMPTY_LIST, false);
        SafeDeleteRefactoring refactoringReferringClass = new SafeDeleteRefactoring(new Element[]{referringMethod});
        RefactoringSession result = null;
        Problem probObject = refactoringReferringClass.checkParameters();
        assertNull(refactoringReferringClass.checkParameters());
        result = RefactoringSession.create("SafeDelete Referring Method");
        assertNull(refactoringReferringClass.prepare(result));
        assertNull(result.doRefactoring(true));
    }
    
}
