/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.test.refactoring.pullup;

import java.io.IOException;
import java.util.Collections;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.refactoring.api.PullUpRefactoring;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.test.refactoring.Utility;
import org.openide.filesystems.FileStateInvalidException;

/**
 *
 * @author Jan Becicka
 */
public class PullUpRefactoringTest extends NbTestCase {
    
    private JavaClass newClass;
    private JavaClass baseClass;
    JavaModelPackage pkg;
    public PullUpRefactoringTest() {
        super("PullUpRefactoringTest");
    }
    
    protected void setUp() {
    	// this is the best place to setup test enviroment (invoked once per running the whole test suite)
        newClass = (JavaClass) Utility.findClass("org.netbeans.test.pullup.TestNewClass");
        baseClass = (JavaClass) Utility.findClass("org.netbeans.test.pullup.TestBaseClass");
        pkg = (JavaModelPackage) newClass.refOutermostPackage();
    }
    
    // this method has "test" prefix - it describes one test case
    public void testSimplePullUp() throws FileStateInvalidException, IOException {
        // initialize refactoring and set parameters
        PullUpRefactoring refactoring = new PullUpRefactoring(newClass);
        refactoring.setTargetType(baseClass);
        Method m = newClass.getMethod("newMethod", Collections.EMPTY_LIST, false);
        PullUpRefactoring.MemberInfo[] members = new PullUpRefactoring.MemberInfo[] {new PullUpRefactoring.MemberInfo(m, false)};
        refactoring.setMembers(members);

        // we don't expect any problems from checkParameters
        assertNull(refactoring.checkParameters());
        
        RefactoringSession result = RefactoringSession.create("Pullup methd newMethod");
        // we don't expect any problems from prepare
        assertNull(refactoring.prepare(result));
        
        // we don't expect any problems during refactoring
        assertNull(result.doRefactoring(true));

        // let's check if all files were correctly refactored
        assertFiles();
    }
    
    // put your test sources into test project: refactoring/test/unit/data/projects/default/src/..
    // test project including your files will be available for refactoring during test execution
    private static final String FILE1 = "org/netbeans/test/pullup/TestNewClass.java";
    private static final String FILE2 = "org/netbeans/test/pullup/TestBaseClass.java";
    
    public void assertFiles() throws FileStateInvalidException, IOException {
        // compare refactored files with golden files
        // method getGoldenFile(name) will return this file:
        // refactoring/experimantal/unit/data/goldenfiles/$full_name_of_this_class$/$name$
        // in this particular case refactoring/experimantal/unit/data/goldenfiles/org/netbeans/test/refactoring/PullUpRefactoringTest/TestNewClass.pass
        assertFile(Utility.getFile(getDataDir(), FILE1), getGoldenFile("TestNewClass.pass"), getWorkDir());    
        assertFile(Utility.getFile(getDataDir(), FILE2), getGoldenFile("TestBaseClass.pass"), getWorkDir());    
    }
    
}
