/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.test.refactoring.encapsulate;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.*;
import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.EncapsulateFieldRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.test.refactoring.Utility;
import org.openide.filesystems.FileStateInvalidException;

/**
 * Test encapsualte field refactoring. Specialized to fields with dimensions 
 * and field group, i.e.<code>int a[], b;</code>
 *
 * @author  Pavel Flaska
 */
public class DimEncapsulateTest extends NbTestCase {
    
    JavaClass clazz;
    JavaModelPackage pkg;
    String[] fieldNames = new String[] { "b", "a", "c", "d", "e" };
    
    /** Creates a new instance of DimEncapsulateTest */
    public DimEncapsulateTest() {
        super("DimEncapsulateTest");
    }
    
    protected void setUp() {
        clazz = (JavaClass) Utility.findClass("org.netbeans.test.encapsulate.DimEncapsulate");
        pkg = (JavaModelPackage) clazz.refOutermostPackage();
    }
    
    public void testEncapsulateFields() throws FileStateInvalidException, IOException {
        // initialize refactoring
        for (int i = 0; i < 5; i++) {
            Field field = clazz.getField(fieldNames[i], false);
            EncapsulateFieldRefactoring refactoring = new EncapsulateFieldRefactoring(field);
            refactoring.setGetterName("get" + field.getName().toUpperCase());
            refactoring.setSetterName("set" + field.getName().toUpperCase());
            refactoring.setMethodModifiers(Modifier.PUBLIC);
            refactoring.setFieldModifiers(Modifier.PRIVATE);
            refactoring.setAlwaysUseAccessors(true);
            refactoring.checkParameters();
            RefactoringSession result = RefactoringSession.create("encapsulate field");
            refactoring.prepare(result);
            result.doRefactoring(true);
        }
        assertFile(
            Utility.getFile(getDataDir(), "org/netbeans/test/encapsulate/DimEncapsulate.java"),
            getGoldenFile("testEncapsulateFields_DimEncapsulateTest.pass"), getWorkDir()
        );
    }

}
