/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.refactoring.ui;

import javax.swing.DefaultComboBoxModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.refactoring.api.UseSuperTypeRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.openide.util.NbBundle;

/*
 * UseSuperTypePanel.java
 *
 * Created on June 20, 2005
 *
 * @author  Bharath Ravi Kumar
 */

/**
 * The panel for the use super type refactoring
 */
public class UseSuperTypePanel extends CustomRefactoringPanel {
    
    private final UseSuperTypeRefactoring refactoring;
    /**
     * Creates new form UseSuperTypePanel
     * @param refactoring The use super type refactoring that is
     * used by this panel
     */
    public UseSuperTypePanel(UseSuperTypeRefactoring refactoring, final ParametersPanel parent) {
        this.refactoring = refactoring;
        initComponents();
        Element subType = refactoring.getTypeElement();
        String title = null;
        if(!(subType instanceof JavaClass))
            title = NbBundle.getMessage(UseSuperTypePanel.class, "LBL_UseSuperType");
        else{
            String className = ((JavaClass)subType).getName();
            title = NbBundle.getMessage(UseSuperTypePanel.class, "LBL_UseSyperTypeTitle", className);
        }
        setName(title);
        superTypeList.setCellRenderer(new UIUtilities.JavaElementListCellRenderer() {
            /** Returns display text of the class. The text is returned in the
             * following format: SimpleName (package.name). If the class is an inner
             * class the text is: Outer.SimpleName (package.name).
             */
            protected String extractText(Object value) {
                // the value is always an instance of JavaClass
                JavaClass topLevel = (JavaClass) value;
                Object current;
                // iterate up through the parents to find the top-level class
                while ((current = topLevel.refImmediateComposite()) instanceof JavaClass) {
                    topLevel = (JavaClass) current;
                }
                // derive the package name by subtracting the simple name of top-level class
                // from the fully qualified name of the top-level class
                String packageName = topLevel.getName();
                packageName = packageName.substring(0, packageName.length() - topLevel.getSimpleName().length());
                // now, get the class name by subtracting the package name from the class FQN
                String className = ((JavaClass) value).getName().substring(packageName.length());
                // remove the ending dot from the package name and surrond it by parentheses
                if (packageName.length() > 0) {
                    packageName = " (" + packageName.substring(0, packageName.length() - 1) + ")"; // NOI18N
                }
                // create the displayText (concatenate the class name and package name)
                return className.concat(packageName);
            }
        });
        superTypeList.setModel(new DefaultComboBoxModel(refactoring.getCandidateSuperTypes()));
        superTypeList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        superTypeList.setSelectedIndex(0);
        superTypeList.addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                parent.stateChanged(null);
            }
        });
    }
    
    public void initialize() {
    }
    
    /**
     * Returns the targer super type to be used
     * @return The target super type JavaClass
     */
    public JavaClass getSuperType(){
        return (JavaClass) superTypeList.getSelectedValue();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        label = new javax.swing.JLabel();
        listScrollPane = new javax.swing.JScrollPane();
        superTypeList = new javax.swing.JList();

        setLayout(new java.awt.GridBagLayout());

        setMaximumSize(new java.awt.Dimension(600, 500));
        setPreferredSize(new java.awt.Dimension(300, 200));
        label.setLabelFor(superTypeList);
        org.openide.awt.Mnemonics.setLocalizedText(label, org.openide.util.NbBundle.getBundle(UseSuperTypePanel.class).getString("DSC_UseSuperType"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(label, gridBagConstraints);

        superTypeList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        listScrollPane.setViewportView(superTypeList);
        superTypeList.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(UseSuperTypePanel.class, "ACSD_SupertypeToUse"));
        superTypeList.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(UseSuperTypePanel.class, "ACSD_SupertypeToUseDescription"));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(listScrollPane, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents
        
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel label;
    private javax.swing.JScrollPane listScrollPane;
    private javax.swing.JList superTypeList;
    // End of variables declaration//GEN-END:variables
    
}
