/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.refactoring.ui;
import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementReference;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.spi.ui.AbstractRefactoringAction;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;


/**
 * The action representing a Safe Delete refactoring
 * @author Bharath Ravikumar
 */
public class SafeDeleteAction extends AbstractRefactoringAction {
    
    
    /**
     * Creates a new Instance of SafeDeleteAction
     */
    public SafeDeleteAction() {
        //TODO:Do not hard code this String
        super(NbBundle.getMessage(SafeDeleteAction.class, "LBL_SafeDel_Action"), null); // NOI18N
        putValue("noIconInMenu", Boolean.TRUE); // NOI18N
        
    }
    
    /**
     * Indicates whether this action should be enabled  given
     * the node selections
     * @param activatedNodes The selected nodes
     * @return a value indicating whether this action should
     * be enabled
     */
    protected boolean enabled(org.openide.nodes.Node[] activatedNodes) {
        // if no nodes are currently active, the action should be disabled
        if (activatedNodes.length == 0) return false;
        
        DataObject dobj = (DataObject) activatedNodes[0].getCookie(DataObject.class);
        //Copied from Pullup refactoring
        // Check if the dataobject is instance of JavaDataObejct and that it represents a file
        // that is on the IDE classpath (belongs to one of open projects)
        if ((dobj instanceof JavaDataObject) && ((JMManager) JavaMetamodel.getManager()).mergedCPContains(dobj.getPrimaryFile())) {
            // now go through all remaining nodes and check whether they are associated with the same DataObject
            for (int i = 1; i < activatedNodes.length; i++) {
                if (!dobj.equals(activatedNodes[i].getCookie(DataObject.class))) {
                    return false;
                }
            }
            return true;
        } else {
            return false;
        }
    }
    
    /**
     * Creates a new SafeDeleteUI, initialized with the list
     * of elements that will be affected.
     * @param nodes The selected Nodes
     * @param selectedElement The Selected elements
     * @return A new instance of SafeDeleteUI
     */
    protected org.netbeans.modules.refactoring.spi.ui.RefactoringUI createRefactoringUI(org.openide.nodes.Node[] nodes, org.netbeans.jmi.javamodel.Element selectedElement) {
        
        Element[] selectedElements;
        if (selectedElement == null) {
            // selected element == null => action was invoked on nodes
            ArrayList elements = new ArrayList();
            //Now, get all the Java elements for each node
            for (int i = 0; i < nodes.length; i++) {
                Node selNode = nodes[i];
                Element element = (Element) selNode.getLookup().lookup(Element.class);
                if (element == null) {
                    // if the node does not have a java element associated with it
                    // try of it has at least JavaDataObject associated
                    JavaDataObject jDataObj = (JavaDataObject) selNode.getCookie(JavaDataObject.class);
                    if (jDataObj != null) {
                        // Next, get the Java Element under each node through the
                        //corresponding Resource
                        Resource resource = JavaModel.getResource(jDataObj.getPrimaryFile());
                        if(resource != null) {
                            extractContainedElements(resource, elements);
                            elements.add(resource);
                        }
                    }
                } else {
                    // if the Java element was successfully extracted from a selected
                    // node, add it to the list of selected elements
                    elements.add(element);
                }
            }
            selectedElements = (Element[]) elements.toArray(new Element[elements.size()]);
        } else {
            
            if(selectedElement instanceof ElementReference){
                selectedElement = ((ElementReference) selectedElement).getElement();
                selectedElements = new Element[] {selectedElement};
            } else if(selectedElement instanceof Resource){
                //Fix for 60346. Extract the underlying classes in the java file
                ArrayList elements = new ArrayList();
                extractContainedElements((Resource) selectedElement, elements);
                elements.add(selectedElement);
                selectedElements = (Element[]) elements.toArray(new Element[elements.size()]);
            } else
                selectedElements = new Element[] {selectedElement};
        }
        
        return new SafeDeleteUI(selectedElements);
    }
    
    
//Private helper methods---------
    
    private void extractContainedElements(final Resource resource, final ArrayList elements) {
        if(resource.getClassifiers().size() > 0) {
            Iterator resIterator = resource.getClassifiers().iterator();
            while(resIterator.hasNext())
                elements.add(resIterator.next());
        }
    }
    
}
