/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.ui;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.*;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.LocalVariable;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

/**
 *
 * @author Martin Matula
 */
public class RenameRefactoringUI implements RefactoringUI, RefactoringUIBypass {
    private final AbstractRefactoring refactoring;
    private final String oldName;
    private final String dispOldName;
    private String newName;
    private RenamePanel panel;
    private boolean fromListener = false;
    private RefObject jmiObject;
    private FileObject byPassFolder;
    private boolean byPassPakageRename;
    private boolean pkgRename = true;

    RenameRefactoringUI(RefObject jmiObject, FileObject folder, boolean packageRename) {
        this.jmiObject = jmiObject;
        pkgRename = packageRename;
        if (jmiObject == null || jmiObject instanceof JavaPackage) {
            if (folder == null) {
                folder = JavaMetamodel.getManager().getClassPath().findResource(((JavaPackage) jmiObject).getName().replace('.','/'));
                if (folder == null) {
                    //package declaration is invalid
                    Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
                    DataObject dob = (DataObject) nodes[0].getCookie(DataObject.class);
                    folder = dob.getFolder().getPrimaryFile();
                }
            }
            this.refactoring = createMoveClassRefactoring(folder, packageRename);
            String packageName = jmiObject != null ? ((JavaPackage) jmiObject).getName():null;
            if (!packageRename) {
                oldName = folder.getName();
            } else {
                if (packageName != null) {
                    oldName = "".equals(packageName) ? NbBundle.getBundle("org.netbeans.modules.java.project.Bundle").getString("LBL_DefaultPackage") : packageName;
                } else {
                    oldName = ClassPath.getClassPath(folder, ClassPath.SOURCE).getResourceName(folder).replace('/','.');
                }
            }
        } else if (jmiObject instanceof JavaClass) {
            this.refactoring = new RenameRefactoring(jmiObject);
            Object comp = jmiObject.refImmediateComposite();
            if (comp instanceof Resource) {
                FileObject fo = JavaModel.getFileObject((Resource)comp);
                String name = fo.getName();
                for (Iterator iter = ((Resource)comp).getClassifiers().iterator(); iter.hasNext(); ) {
                    Object obj = iter.next();
                    if (obj instanceof JavaClass) {
                        String sName = ((JavaClass) obj).getSimpleName();
                        if (name.equals(sName)) {
                            name = ((JavaClass) jmiObject).getSimpleName();
                            break;
                        }
                    } // if
                } // for
                oldName = name;
            } else {
                oldName = ((JavaClass) jmiObject).getSimpleName();
            }
        } else {
            this.refactoring = new RenameRefactoring(jmiObject);
            if (jmiObject instanceof NamedElement) {
                if (jmiObject instanceof Resource) {
                    oldName = JavaMetamodel.getManager().getDataObject((Resource)jmiObject).getName();
                } else
                    oldName = ((NamedElement) jmiObject).getName();
            } else {
                oldName = "";
            }
        }
        dispOldName = oldName;
    }
    
    public RenameRefactoringUI(RefObject jmiObject) {
        this(jmiObject, (FileObject) null, true);
    }
    
    private MoveClassRefactoring createMoveClassRefactoring(FileObject folder, boolean packageRename) {
        return new MoveClassRefactoring(folder, packageRename);
    }

    RenameRefactoringUI(RefObject jmiObject, String newName) {
        this.refactoring = new RenameRefactoring(jmiObject);
        this.jmiObject = jmiObject;
        oldName = newName;
        //[FIXME] this should be oldName of refactored object
        this.dispOldName = newName;
        fromListener = true;
    }
    
    RenameRefactoringUI(FileObject folder, String newName, boolean packageRename) {
        this.refactoring = createMoveClassRefactoring(folder, packageRename);
        pkgRename = packageRename;
        oldName = newName;
        //[FIXME] this should be oldName of refactored object
        this.dispOldName = newName;
        fromListener = true;
        this.byPassFolder = folder;
        this.byPassPakageRename = packageRename;
        
    }
    
    
    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(org.netbeans.modules.refactoring.spi.ui.ParametersPanel parent) {
        if (panel == null) {
            String name = oldName;
            String suffix = "";
            if (jmiObject instanceof JavaClass) {
                suffix  = ((JavaClass) jmiObject).isInterface() ? getString("LBL_Interface") : getString("LBL_Class");
            } else if (jmiObject instanceof Method) {
                suffix = getString("LBL_Method");
            } else if (jmiObject instanceof Field) {
                suffix = getString("LBL_Field");
            } else if (jmiObject instanceof LocalVariable) {
                suffix = getString("LBL_LocalVar");
            } else if (jmiObject instanceof JavaPackage || (jmiObject == null && fromListener)) {
                suffix = pkgRename ? getString("LBL_Package") : getString("LBL_Folder");
            } else if (jmiObject instanceof Parameter) {
                suffix = getString("LBL_Parameter");
            } 
            suffix = suffix + " " + name; // NOI18N
            panel = new RenamePanel(name, parent, NbBundle.getMessage(RenamePanel.class, "LBL_Rename") + " " + suffix, !fromListener, fromListener && !byPassPakageRename);
        }
        return panel;
    }
    
    private static String getString(String key) {
        return NbBundle.getMessage(RenameRefactoringUI.class, key);
    }

    public org.netbeans.modules.refactoring.api.Problem setParameters() {
        newName = panel.getNameValue();
        if (refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring) refactoring).setNewName(newName);
            ((RenameRefactoring) refactoring).setSearchInComments(panel.searchJavadoc());            
        } else {
            ((MoveClassRefactoring) refactoring).setTargetPackageName(newName);
        }
        return refactoring.checkParameters();
    }
    
    public org.netbeans.modules.refactoring.api.Problem checkParameters() {
        newName = panel.getNameValue();
        if (refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring) refactoring).setNewName(newName);
        } else {
            ((MoveClassRefactoring) refactoring).setTargetPackageName(newName);
        }
        return refactoring.fastCheckParameters();
    }

    public org.netbeans.modules.refactoring.api.AbstractRefactoring getRefactoring() {
        return refactoring;
    }

    public String getDescription() {
        return new MessageFormat(NbBundle.getMessage(RenameAction.class, "DSC_Rename")).format (
                    new Object[] {dispOldName, newName}
                );
    }

    public String getName() {
        return NbBundle.getMessage(RenameAction.class, "LBL_Rename");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        String postfix;
        if (jmiObject instanceof JavaPackage)
            postfix = ".JavaPackage";//NOI18N
        else if (jmiObject instanceof JavaClass)
            postfix = ".JavaClass";//NOI18N
        else if (jmiObject instanceof Method)
            postfix = ".Method";//NOI18N
        else if (jmiObject instanceof Field)
            postfix = ".Field";//NOI18N
        else
            postfix = "";
        
        return new HelpCtx(RenameRefactoringUI.class.getName() + postfix);
    }
    
    public boolean isRefactoringBypassRequired() {
        return !panel.isUpdateReferences();
    }
    public void doRefactoringBypass() throws IOException {
        DataObject dob;
        if (byPassFolder != null) {
            dob = DataFolder.findFolder(byPassFolder);
        } else {
            dob = JMManager.getManager().getDataObject(((Element) ((RenameRefactoring)refactoring).getRefactoredObject()).getResource());
        }
        dob.rename(panel.getNameValue());
    }
}
