/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.refactoring.ui;
import java.io.IOException;
import java.util.Iterator;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.RenameHandler;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.classpath.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;

/**
 *
 * @author Jan Becicka
 */
public class RenameHandlerImpl implements RenameHandler {

    public void handleRename(Node node, String newName) {
        DataObject dob = (DataObject) node.getCookie(DataObject.class);
        FileObject fo = dob.getPrimaryFile();
        if (!Util.isUnderSourceRootOfOpenProjects(fo)) {
            try {
                dob.rename(newName);
            } catch (IOException ioe) {
                throw (IllegalArgumentException) new IllegalArgumentException().initCause(ioe);
            }
            return;
        }
        RenameAction a = (RenameAction) RenameAction.findObject(RenameAction.class, true);
        Resource cr = JavaModel.getResource(fo);
        Element representedObject = cr;
        if (cr != null) {
            for (Iterator it = cr.getClassifiers().iterator(); it.hasNext();) {
                Object obj = it.next();
                if (!(obj instanceof JavaClass))
                    continue;
                JavaClass cls = (JavaClass) obj;
                representedObject = cls;
                if (node.getName().equals(cls.getSimpleName()) || representedObject == null) {
                    break;
                }
            }
        }
        
        a.performAction(representedObject, newName);
    }
}
