/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.refactoring.ui;

import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.spi.ui.AbstractRefactoringAction;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/** Action that invokes Pull Down refactoring.
 *
 * @author Pavel Flaska
 */
public class PushDownAction extends AbstractRefactoringAction {
    
    /** Creates a new instance of PushDownAction
     */
    public PushDownAction() {
        super(NbBundle.getMessage(PushDownAction.class, "LBL_PushDown_Action"), null); // NOI18N
        putValue("noIconInMenu", Boolean.TRUE); // NOI18N
    }
    
    /** Method responsible for creating RefactoringUI object.
     * @param nodes Active nodes to perform the refactoring on.
     * @param selectedElement Element to perform the refactoring on or null if the action
     *      was not invoked from the editor - in that case the active nodes take
     *      the precedence.
     * @return RefactoringUI object for Push Down refactoring.
     */
    protected RefactoringUI createRefactoringUI(Node[] nodes, Element selectedElement) {
        Element[] selectedElements;
        if (selectedElement == null) {
            // selected element is null -> action was invoked on nodes
            ArrayList elements = new ArrayList();
            
            // collect Java elements for active nodes
            for (int i = 0; i < nodes.length; i++) {
                Node selNode = nodes[i];
                Element element = (Element) selNode.getLookup().lookup(Element.class);

                if (element == null) {
                    // if the node does not have a java element associated with it
                    // try of it has at least JavaDataObject associated
                    Object ob = selNode.getCookie(JavaDataObject.class);
                    if (ob != null) {
                        // if it does, take the resource correcponding to that
                        // JavaDataObject as Java element the action should be
                        // performed on
                        JavaDataObject o = (JavaDataObject) ob;
                        element = JavaModel.getResource(o.getPrimaryFile());
                    }
                }
                if (element != null) {
                    // if the Java element was successfully extracted from a given
                    // node, add it to the list of selected elements
                    elements.add(element);
                }
            }
            selectedElements = (Element[]) elements.toArray(new Element[elements.size()]);
        } else {
            selectedElements = new Element[] {selectedElement};
        }
        // create PushDownRefactoringUI for the selected elements and return it
        return new PushDownRefactoringUI(selectedElements);
    }
    
    /** Method that determines whether this action is enabled for the active nodes.
     * @param activatedNodes Active nodes.
     * @return Boolean indicating whether the action is enabled.
     */
    protected boolean enabled(Node[] activatedNodes) {
        // if no nodes are active, the action should be disabled
        if (activatedNodes.length == 0) return false;
        
        // the action should be enabled only if all selected nodes are associated
        // with the same JavaDataObject (i.e. they are all declared in the same Java file)
        // so, let's get dataobject from the first activated node
        DataObject dobj = (DataObject) activatedNodes[0].getCookie(DataObject.class);
        // check if the dataobject is instance of JavaDataObejct and that it represents a file
        // that is on the IDE classpath (belongs to one of open projects)
        if ((dobj instanceof JavaDataObject) && ((JMManager) JavaMetamodel.getManager()).mergedCPContains(dobj.getPrimaryFile())) {
            // now go through all remaining nodes and check whether they are associated with the same DataObject
            for (int i = 1; i < activatedNodes.length; i++) {
                if (!dobj.equals(activatedNodes[i].getCookie(DataObject.class))) {
                    return false;
                }
            }
            return true;
        } else {
            return false;
        }
    }
}
